package com.agilex.healthcare.mobilehealthplatform.restservice.serializer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;

public class SampleReadXmlTest {
	private static final int numberOfRuns = 10000;

	private InputStream getAsStream(String resourceName) {
		InputStream resource = this.getClass().getResourceAsStream(resourceName);
		return resource;
	}

	@Test
	public void loadArticleFromXml() throws JAXBException {
		JAXBContext ctx = JAXBContext.newInstance(new Class[] { LearnArticle.class });
		Unmarshaller um = ctx.createUnmarshaller();
		InputStream resourceStream = getAsStream("article.1.xml");
		LearnArticle article = (LearnArticle) um.unmarshal(resourceStream);

		assertEquals("1", article.getId());
		assertEquals("What is an article?", article.getTitle());
		assertEquals(3349, article.getContent().length());
		assertNotNull(article.getLink().getSelfLink());
	}

	@Test
	@Ignore
	public void load10000ArticlesNoObjectCache() throws JAXBException {
		for (int i = 1; i < numberOfRuns; i++) {
			JAXBContext ctx = JAXBContext.newInstance(new Class[] { LearnArticle.class });
			Unmarshaller um = ctx.createUnmarshaller();
			InputStream resourceStream = getAsStream("article.1.xml");
			um.unmarshal(resourceStream);
		}
	}

	@Test
	@Ignore
	public void load10000ArticlesWithContextCache() throws JAXBException {
		JAXBContext ctx = JAXBContext.newInstance(new Class[] { LearnArticle.class });
		for (int i = 1; i < numberOfRuns; i++) {
			Unmarshaller um = ctx.createUnmarshaller();
			InputStream resourceStream = getAsStream("article.1.xml");
			um.unmarshal(resourceStream);
		}
	}

	// DO NOT DO THIS: MARSHALLER IS NOT THREAD SAFE
	// http://jaxb.java.net/guide/Performance_and_thread_safety.html
	@Test
	@Ignore
	public void load10000ArticlesWithMarshallerCache() throws JAXBException {
		JAXBContext ctx = JAXBContext.newInstance(new Class[] { LearnArticle.class });
		Unmarshaller um = ctx.createUnmarshaller();
		for (int i = 1; i < numberOfRuns; i++) {
			InputStream resourceStream = getAsStream("article.1.xml");
			um.unmarshal(resourceStream);
		}
	}

	@Test
	public void loadJson() throws JsonParseException, JsonMappingException, IOException {

		InputStream resourceStream = getAsStream("article.1.json");

		ObjectMapper mapper = new ObjectMapper();
		LearnArticle article = mapper.readValue(resourceStream, LearnArticle.class);

		assertEquals("articleID", article.getId());
		assertEquals("What is an article?", article.getTitle());
		assertEquals(3345, article.getContent().length());
	}

	@Test
	@Ignore
	public void loadJson10000Articles() throws JsonParseException, JsonMappingException, IOException {
		for (int i = 1; i < numberOfRuns; i++) {
			ObjectMapper mapper = new ObjectMapper();
			InputStream resourceStream = getAsStream("article.1.json");
			mapper.readValue(resourceStream, LearnArticle.class);
		}
	}

	@Test
	@Ignore
	public void loadJson10000ArticlesCacheObjectMapper() throws JsonParseException, JsonMappingException, IOException {
		ObjectMapper mapper = new ObjectMapper();
		for (int i = 1; i < numberOfRuns; i++) {
			InputStream resourceStream = getAsStream("article.1.json");
			mapper.readValue(resourceStream, LearnArticle.class);
		}
	}
}
