package com.agilex.healthcare.mobilehealthplatform.restservice.serializer;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;
import org.springframework.http.MediaType;

public class MediaTypeComparerTest {

	@Test
	public void handle() {
		assertTrue(MediaTypeComparer.isCompatibleWith(MediaType.TEXT_PLAIN, "text/plain"));
	}

	@Test
	public void handleFirst() {
		assertTrue(MediaTypeComparer.isCompatibleWith(MediaType.TEXT_PLAIN, "text/plain", "text/html"));
	}

	@Test
	public void handleSecond() {
		assertTrue(MediaTypeComparer.isCompatibleWith(MediaType.TEXT_PLAIN, "text/html", "text/plain"));
	}

	@Test
	public void doesNotHandle1() {
		assertFalse(MediaTypeComparer.isCompatibleWith(MediaType.TEXT_PLAIN, "text/other"));
	}

	@Test
	public void doesNotHandleList() {
		assertFalse(MediaTypeComparer.isCompatibleWith(MediaType.TEXT_PLAIN, "text/other", "text/other"));
	}

	@Test
	public void handleWildcare() {
		assertTrue(MediaTypeComparer.isCompatibleWith(MediaType.TEXT_PLAIN, "text/*"));
	}

	@Test
	public void handleExtension() {
		assertTrue(MediaTypeComparer.isCompatibleWith(MediaType.APPLICATION_ATOM_XML, "application/*+xml"));
	}

	@Test
	public void doesNotHandleWildcare() {
		assertFalse(MediaTypeComparer.isCompatibleWith(MediaType.TEXT_PLAIN, "application/*"));
	}
}
