package com.agilex.healthcare.mobilehealthplatform.qunit;

import static org.junit.Assert.fail;

import java.util.List;

import org.apache.log4j.Logger;
import org.junit.Ignore;
import org.junit.Test;

import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

@Ignore
public class QUnitTest {

	private static final Logger LOGGER = Logger.getLogger(QUnitTest.class);
	
    @Test
    public void testAll() throws Exception {
        WebClient webClient = new WebClient();
		webClient.setJavaScriptEnabled(true);
		webClient.setThrowExceptionOnFailingStatusCode(true);
	    webClient.setThrowExceptionOnScriptError(true);
		webClient.setAjaxController(new NicelyResynchronizingAjaxController());

        HtmlPage page = webClient.getPage("http://localhost:8080/MobileHealthPlatformWeb/test/test.html");
		webClient.waitForBackgroundJavaScript(100000);
        
		//System.out.println(page.asXml());
		
        HtmlElement element = page.getHtmlElementById("qunit-testresult");
        
        int failed = checkForFailedTests(element);
        
        if (failed > 0) {
        	printFailedTests(page);
        	
        	fail("Failures found in QUnit tests");
        }
    }
    
    private int checkForFailedTests(HtmlElement element) {
        int failed = 0;
        DomNodeList<HtmlElement> spanElements = element.getElementsByTagName("span");
        for (HtmlElement spanElement : spanElements) {
        	String attribute = spanElement.getAttribute("class");
        	if (attribute.equals("failed")) {
        		failed = Integer.parseInt(spanElement.getTextContent());
        	}
        }
        
        return failed;
    }
    
    private void printFailedTests(HtmlPage page) {
    	HtmlElement testResults = page.getHtmlElementById("qunit-tests");
    	List<HtmlElement> failedResults = testResults.getElementsByAttribute("li", "class", "fail");
    	LOGGER.error("");
    	
    	for (HtmlElement failedResult : failedResults) {
    		List<HtmlElement> titles = failedResult.getElementsByAttribute("span", "class", "test-name");
    		for (HtmlElement title : titles) {
        		LOGGER.error("#####################################################");
        		LOGGER.error("");
    			LOGGER.error(String.format("Test [%s] failed", title.getTextContent()));
    		}
    		List<HtmlElement> results = failedResult.getElementsByAttribute("li", "class", "fail");
    		for (HtmlElement result : results) {
        		LOGGER.error("------------------------------------");
    			LOGGER.error(result.getTextContent());
    			LOGGER.error("");
    		}
    	}

		LOGGER.error("#####################################################");
    }
}