package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalObservation;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ObservationTypeCode;
import com.agilex.healthcare.mobilehealthplatform.domain.code.VitalSectionCode;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

public class VitalsPDFReportTest extends AbstractPDFReportTest {
	final Date DATE = DateHelper.parseDate("04/01/2012");
	final String SYSTOLIC = "120";
	final String DIASTOLIC = "85";
	final String PULSE = "70";
	final String WEIGHT = "160";
	final String HEIGHT = "80";
	final String TEMP = "101";
	final String RESP_RATE = "55";
	final String PAIN = "7";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.vital, true);
		context.setInformation(Domain.vital, createVitals());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.limited", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.date", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.bp", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.pulse", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.weight", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.height", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.temp", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.respRate", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.vitals.pain", null, locale));
		assertTextList.add(DateHelper.formatDate(DATE));
		assertTextList.add(SYSTOLIC);
		assertTextList.add(PULSE);
		assertTextList.add(DIASTOLIC);
		assertTextList.add(WEIGHT);
		assertTextList.add(PULSE);
		assertTextList.add(RESP_RATE);
		assertTextList.add(PAIN);
		return assertTextList.iterator();
	}
	
	private VitalEntries createVitals() {
		
		VitalEntries vitalEntries = new VitalEntries();
		
		// === PULSE
		VitalEntry pulseEntry = new VitalEntry();
		pulseEntry.setEntryDate(DATE);
		pulseEntry.setSection( VitalSectionCode.Pulse ) ; 
		
		VitalObservation pulseObservation = new VitalObservation();
		pulseObservation.setType(ObservationTypeCode.HEART_BEAT);
		pulseObservation.setValue(PULSE);
		pulseObservation.setValueUnits("BPM");
		pulseEntry.addObservation(pulseObservation);
		
		vitalEntries.add( pulseEntry ) ; 
		
		// === BP
		VitalEntry bpEntry = new VitalEntry( ) ;
		bpEntry.setEntryDate( DATE );
		bpEntry.setSection( VitalSectionCode.BloodPressure ) ; 

		VitalObservation bpSysObservation = new VitalObservation();
		bpSysObservation.setType(ObservationTypeCode.INTRAVASCULAR_SYSTOLIC);
		bpSysObservation.setValue(SYSTOLIC);
		bpSysObservation.setValueUnits("mm(hg)");
		bpEntry.addObservation( bpSysObservation );
		
		VitalObservation bpDiaObservation = new VitalObservation();
		bpDiaObservation.setType(ObservationTypeCode.INTRAVASCULAR_DIASTOLIC);
		bpDiaObservation.setValue(DIASTOLIC);
		bpDiaObservation.setValueUnits("mm(hg)");
		bpEntry.addObservation( bpDiaObservation);
		
		vitalEntries.add( bpEntry ) ; 
		
		// === WEIGHT
		VitalEntry weightEntry = new VitalEntry( ) ; 
		weightEntry.setEntryDate(DATE);
		weightEntry.setSection( VitalSectionCode.Weight );  
		
		VitalObservation weightObservation = new VitalObservation();
		weightObservation.setType(ObservationTypeCode.WEIGHT);
		weightObservation.setValue(WEIGHT);
		weightEntry.addObservation(weightObservation);
		
		vitalEntries.add( weightEntry ) ; 
		
		// === HEIGHT
		VitalEntry heightEntry = new VitalEntry( ) ;
		heightEntry.setEntryDate(DATE);
		heightEntry.setSection(VitalSectionCode.Height);
		
		VitalObservation heightObservation = new VitalObservation();
		heightObservation.setType(ObservationTypeCode.HEIGHT);
		heightObservation.setValue(HEIGHT);
		heightEntry.addObservation(heightObservation ) ; 
		
		vitalEntries.add( heightEntry ) ; 
		
		// === TEMP
		VitalEntry tempEntry = new VitalEntry( ) ; 
		tempEntry.setEntryDate(DATE);
		tempEntry.setSection(VitalSectionCode.Temperature) ; 
		
		VitalObservation tempObservation = new VitalObservation();
		tempObservation.setType(ObservationTypeCode.BODY_TEMPERATURE);
		tempObservation.setValue(TEMP);
		tempObservation.setValueUnits("degrees");
		tempEntry.addObservation(tempObservation) ; 
		
		vitalEntries.add( tempEntry ) ; 
		
		// === RESP
		VitalEntry respEntry = new VitalEntry( ) ; 
		respEntry.setEntryDate( DATE ) ; 
		respEntry.setSection( VitalSectionCode.Respiration ) ; 
		
		VitalObservation respObservation = new VitalObservation();
		respObservation.setType(ObservationTypeCode.RESPIRATION);
		respObservation.setValue(RESP_RATE);
		respEntry.addObservation(respObservation);
		
		vitalEntries.add( respEntry ) ; 
		
		// === PAIN
		VitalEntry painEntry = new VitalEntry( ) ; 
		painEntry.setEntryDate(DATE);
		painEntry.setSection(VitalSectionCode.Pain);
		VitalObservation painObservation = new VitalObservation();
		painObservation.setType(ObservationTypeCode.PAIN);
		painObservation.setValue(PAIN);
		painEntry.addObservation(painObservation);
		
		vitalEntries.add(painEntry) ; 
		
//		VitalEntry vitalEntry = new VitalEntry();
//		
//		vitalEntry.setEntryDate(DATE);
//		VitalObservation observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.HEART_BEAT);
//		observation.setValue(PULSE);
//		observation.setValueUnits("BPM");
//		vitalEntry.getVitalObservations().add(observation);
//		observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.INTRAVASCULAR_SYSTOLIC);
//		observation.setValue(SYSTOLIC);
//		observation.setValueUnits("mm(hg)");
//		vitalEntry.getVitalObservations().add(observation);
//		observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.INTRAVASCULAR_DIASTOLIC);
//		observation.setValue(DIASTOLIC);
//		observation.setValueUnits("mm(hg)");
//		vitalEntry.getVitalObservations().add(observation);
//		observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.WEIGHT);
//		observation.setValue(WEIGHT);
//		vitalEntry.getVitalObservations().add(observation);
//		observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.HEIGHT);
//		observation.setValue(HEIGHT);
//		vitalEntry.getVitalObservations().add(observation);
//		observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.BODY_TEMPERATURE);
//		observation.setValue(TEMP);
//		observation.setValueUnits("degrees");
//		vitalEntry.getVitalObservations().add(observation);
//		observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.RESPIRATION);
//		observation.setValue(RESP_RATE);
//		vitalEntry.getVitalObservations().add(observation);
//		observation = new VitalObservation();
//		observation.setType(ObservationTypeCode.PAIN);
//		observation.setValue(PAIN);
//		vitalEntry.getVitalObservations().add(observation);
//		
//		vitalEntries.add(vitalEntry);
		
		return vitalEntries;
	}
}
