package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgery;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

public class SurgeriesPDFReportTest extends AbstractPDFReportTest {
	final String DESCRIPTION = "Tonsillectomy";
	final Date DATE = DateHelper.parseDate("10/03/2009");
	final String FACILITY = "VA";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.surgery, true);
		context.setInformation(Domain.surgery, createSurgeries());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.active", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.surgeries.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.surgeries.description", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.surgeries.date", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.surgeries.facility", null, locale));
		assertTextList.add(DESCRIPTION);
		assertTextList.add(DateHelper.formatDate(DATE));
		assertTextList.add(FACILITY);
		return assertTextList.iterator();
	}
	
	private Surgeries createSurgeries() {
		Surgeries surgeries = new Surgeries();
		Surgery surgery = new Surgery();
		
		surgery.setFacility(FACILITY);
		surgery.setProcedure(DESCRIPTION);
		surgery.setProcedureDate(DATE);
		
		surgeries.add(surgery);
		return surgeries;
	}
}
