package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

public class RadiologyPDFReportTest extends AbstractPDFReportTest {
	final Date DATE = DateHelper.parseDate("07/01/2011");
	final String EXAM = "Chest X-ay PA and Lateral";
	final String FACILITY = "DCVAMC";
	final String REPORT = "Sample Radiology Report";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.radiologyResult, true);
		context.setInformation(Domain.radiologyResult, createRadiologyResults());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.limited", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.radiology.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.radiology.date", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.radiology.exam", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.radiology.facility", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.radiology.radiologyReport", null, locale));
		assertTextList.add(DateHelper.formatDate(DATE));
		assertTextList.add(EXAM);
		assertTextList.add(FACILITY);
		return assertTextList.iterator();
	}
	
	private RadiologyResults createRadiologyResults() {
		RadiologyResults radiologyResults = new RadiologyResults();
		RadiologyResult radiologyResult = new RadiologyResult();
		
		radiologyResult.setFacilityName(FACILITY);
		radiologyResult.setTestName(EXAM);
		radiologyResult.setReport(REPORT);
		radiologyResult.setResultedDate(DATE);
		
		radiologyResults.add(radiologyResult);
		
		return radiologyResults;
	}
}
