package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

public class ProblemsPDFReportTest extends AbstractPDFReportTest {
	final String PROBLEM = "ankle joint pain";
	final Date DATE = DateHelper.parseDate("10/29/2010");
	final String SOURCE = "mock";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.problem, true);
		context.setInformation(Domain.problem, createProblems());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.active", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.problems.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.problems.current", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.problems.date", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.problems.source", null, locale));
		assertTextList.add(PROBLEM);
		assertTextList.add(DateHelper.formatDate(DATE));
		assertTextList.add(SOURCE);
		return assertTextList.iterator();
	}
	
	private Problems createProblems() {
		Problems problems = new Problems();
		
		Problem problem = new Problem();
		problem.setOnsetDate(DATE);
		problem.setSourceSystem(SOURCE);
		problem.setDescription(PROBLEM);
		
		problems.add(problem);
		return problems;
	}
}
