package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.junit.Ignore;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

@Ignore
public class MicrobiologyPDFReportTest extends AbstractPDFReportTest {
	final Date DATE = DateHelper.parseDate("09/01/2011");
	final String TEST = "C&S (BLOOD)";
	final String FACILITY = "VA";
	final String REPORT = "Sample Microbiology Report";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.microLabResult, true);
		context.setInformation(Domain.microLabResult, createMicroLabResults());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.limited", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.microbiology.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.microbiology.date", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.microbiology.test", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.microbiology.facility", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.microbiology.microbiologyReport", null, locale));
		assertTextList.add(DateHelper.formatDate(DATE));
		assertTextList.add(TEST);
		assertTextList.add(FACILITY);
		assertTextList.add(REPORT);
		return assertTextList.iterator();
	}

	private LabResults createMicroLabResults() {
		LabResults labResults = new LabResults();
		LabResult labResult = new LabResult();
		labResult.setResultedDate(DATE);
		labResult.setTestname(TEST);
		labResult.setSourceSystem(FACILITY);
		labResult.setValue(REPORT);
		labResults.add(labResult);
		
		return labResults;
	}
}
