package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class MedicationsPDFReportTest extends AbstractPDFReportTest {
	final String MEDICATION = "AMITRIPTYLINE HCL 50 MG TAB";
	final String STATUS = "ACTIVE";
	final String SOURCE = "OUTPATIENT";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.medication, true);
		context.setInformation(Domain.medication, createMedications());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.active", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medications.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medications.activeAndRecentlyExpired", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medications.status", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medications.source", null, locale));
		assertTextList.add(MEDICATION);
		assertTextList.add(STATUS);
		assertTextList.add(SOURCE);
		return assertTextList.iterator();
	}
	
	private Medications createMedications() {
		Medications medications = new Medications();
		Medication medication = new Medication();
		medication.setStatus(STATUS);
		medication.setSourceSystem(SOURCE);
		medication.setDrugName(MEDICATION);
		medications.add(medication);
		return medications;
	}
}
