package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class MedicationHistoryPDFReportTest extends AbstractPDFReportTest {
	final String MEDICATION = "AMITRIPTYLINE HCL 50 MG TAB";
	final String STATUS = "ACTIVE";
	final String SOURCE = "OUTPATIENT";
	final String INSTRUCTIONS = "take two and call me in the morning";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.medicationHistory, true);
		context.setInformation(Domain.medicationHistory, createMedications());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.limited", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medicationHistory.title", null, locale));
		//assertTextList.add(messageSource.getMessage("mbb.report.medicationHistory.name", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medicationHistory.status", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medicationHistory.source", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.medicationHistory.directions", null, locale));
		assertTextList.add(MEDICATION);
		assertTextList.add(STATUS);
		assertTextList.add(SOURCE);
		assertTextList.add(INSTRUCTIONS);
		return assertTextList.iterator();
	}
	
	private Medications createMedications() {
		Medications medications = new Medications();
		Medication medication = new Medication();
		medication.setStatus(STATUS);
		medication.setSourceSystem(SOURCE);
		medication.setDrugName(MEDICATION);
		medication.setSig(INSTRUCTIONS);
		medications.add(medication);
		return medications;
	}
}
