package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Address;
import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.NextOfKin;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class DemographicsPDFReportTest extends AbstractPDFReportTest {
	final String FIRST_NAME = "Michael";
	final String LAST_NAME = "McDonald";
	final String DATE_OF_BIRTH = "01 JAN 2000";
	final DOBDate DOB_DATE = new DOBDate(DateHelper.parse(DATE_OF_BIRTH, "dd MMM yyyy"));
	final String ROOM_BED = "ROOM";
	final String WARD_LOCATION = "WARDLOCATION";
	
	final String STREET1 = "Street1";
	final String STREET2 = "Street2";
	final String STREET3 = "Street3";
	final String CITY = "Chantilly";
	final String STATE = "Virginia";
	final String ZIPCODE = "20151";
	final String HOME = "555-555-5551";
	final String WORK = "555-555-5552";
	final String CELL = "555-555-5553";
	final String PAGER = "555-555-5554";
	final String EMAIL = "test@test.com";
	
	final String NEXT_OF_KIN = "NextOfKin";
	final String RELATIONSHIP = "MOTHER";
	final String PHONE = "555-555-5555";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.demographic, true);
		context.setInformation(Domain.demographic, createDemographics());
		context.setPatient(createPatient());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.active", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.veteran", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.gender", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.dob", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.address", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.home", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.cell", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.work", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.pager", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.email", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.location", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.nextOfKin", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.nextOfKin.name", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.demographics.nextOfKin.relationship", null, locale));
		assertTextList.add(getReportValue(STREET1));
		assertTextList.add(STREET2);
		assertTextList.add(STREET3);
		assertTextList.add(CITY);
		assertTextList.add(STATE);
		assertTextList.add(ZIPCODE);
		assertTextList.add(NEXT_OF_KIN);
		assertTextList.add(RELATIONSHIP);
		assertTextList.add(PHONE);

		assertTextList.add(getReportValue(HOME));
		assertTextList.add(getReportValue(WORK));
		assertTextList.add(getReportValue(CELL));
		assertTextList.add(getReportValue(PAGER));
		assertTextList.add(getReportValue(EMAIL));
		assertTextList.add(FIRST_NAME);
		assertTextList.add(LAST_NAME);
		assertTextList.add(DATE_OF_BIRTH);
		

		String location;
		if (NullChecker.isNotNullish(WARD_LOCATION) && NullChecker.isNotNullish(ROOM_BED)) {
			location = String.format("%s, %s", WARD_LOCATION, ROOM_BED);
		} else if (NullChecker.isNotNullish(WARD_LOCATION)) {
			location = WARD_LOCATION;
		} else if (NullChecker.isNotNullish(ROOM_BED)) {
			location = ROOM_BED;
		} else {
			location = getReportLocationValue(null);
		}
		assertTextList.add(getReportLocationValue(location));
		
		
		return assertTextList.iterator();
	}
	
	private String getReportValue(String value) {
		return NullChecker.isNullish(value) ? messageSource.getMessage("mbb.report.noDataFound", null, locale) : value;
	}
	
	private String getReportLocationValue(String value) {
		return NullChecker.isNullish(value) ? messageSource.getMessage("mbb.report.demographics.notCurrentlyAdmitted", null, locale) : value;
	}
	
	private PatientDemographics createDemographics() {
		PatientDemographics patientDemographics = new PatientDemographics();
		Address address = new Address();
		address.setStreetAddressLine1(STREET1);
		address.setStreetAddressLine2(STREET2);
		address.setStreetAddressLine3(STREET3);
		address.setCity(CITY);
		address.setState(STATE);
		address.setZipCode(ZIPCODE);
		patientDemographics.setAddress(address);
		patientDemographics.setPhoneNumberHome(HOME);
		patientDemographics.setPhoneNumberWork(WORK);
		patientDemographics.setPhoneNumberMobile(CELL);
		patientDemographics.setPhoneNumberPager(PAGER);
		patientDemographics.setEmailAddress(EMAIL);
		
		NextOfKin nextOfKin = new NextOfKin();
		nextOfKin.setName(NEXT_OF_KIN);
		nextOfKin.setRelationship(RELATIONSHIP);
		nextOfKin.setPhoneNumber(PHONE);
		patientDemographics.setNextOfKin(nextOfKin);
		
		return patientDemographics;
	}

	private Patient createPatient() {
		Patient patient = new Patient();
		
		patient.setFirstName(FIRST_NAME);
		patient.setLastName(LAST_NAME);
		patient.setDateOfBirth(DOB_DATE);
		patient.setInpatient(NullChecker.isNotNullish(ROOM_BED) || NullChecker.isNotNullish(WARD_LOCATION));
		patient.setRoombed(ROOM_BED);
		patient.setWardLocation(WARD_LOCATION);
		
		return patient;
	}
}
