package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.utility.DateHelper;

public class CoverPagePDFReportTest extends AbstractPDFReportTest {
	final String FIRST_NAME = "testFirst";
	final String LAST_NAME = "testLast";
	final Date DATE_OF_BIRTH = DateHelper.parseDate("11/11/11");
	final Date REPORT_DATE = DateHelper.parseDate("10/10/10");
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.cover.confidential", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.cover.producedBy", null, locale));
		// CAVEAT: Long text that wrap into multiple lines are currently not matched properly
		//assertTextList.add(messageSource.getMessage("mbb.report.cover.summary", null, locale));
		//assertTextList.add(messageSource.getMessage("mbb.report.cover.questions", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.cover.generatedFor", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.cover.dateOfBirth", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.cover.on", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.title", null, locale));
		assertTextList.add(FIRST_NAME);
		assertTextList.add(LAST_NAME);
		assertTextList.add(DateHelper.format(DATE_OF_BIRTH, DateHelper.REPORT_DETAILED_DATE_FORMAT_NO_TIME));
		String reportDate = DateHelper.format(REPORT_DATE, DateHelper.REPORT_DETAILED_DATE_FORMAT).replace("@", "at");
		assertTextList.add(reportDate);
		return assertTextList.iterator();
	}
	
	@Override
	public PdfGenerationContext buildContext() {
		PdfGenerationContext context = new PdfGenerationContext();

		context.setPatientIdentifier(createPatientIdentifier());
		context.setDateFilter(createDateFilter());
		if (messageSource == null) {
			throw new RuntimeException();
		}
		context.setMessageSource(messageSource);
		context.setLocale(Locale.US);
		Patient patient = new Patient();
		patient.setFirstName(FIRST_NAME);
		patient.setLastName(LAST_NAME);
		patient.setDateOfBirth(new DOBDate(DATE_OF_BIRTH));
		context.setPatient(patient);
		context.setReportDate(REPORT_DATE);
		
		return context;
	}
}
