package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.junit.Ignore;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

@Ignore
public class ChemistryPDFReportTest extends AbstractPDFReportTest {
	final Date DATE = DateHelper.parseDate("11/11/11");
	final String TEST_NAME = "GLUC";
	final String RESULT = "109";
	final String RESULT_UNIT = "mg/dL";
	final String REF_LOW = "60";
	final String REF_HIGH = "300";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.chemLabResult, true);
		context.setInformation(Domain.chemLabResult, createChemLabResults());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.limited", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.chemistry.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.chemistry.date", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.chemistry.test", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.chemistry.result", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.chemistry.refRange", null, locale));
		assertTextList.add(DateHelper.formatDate(DATE));
		assertTextList.add(TEST_NAME);
		assertTextList.add(RESULT);
		assertTextList.add(RESULT_UNIT);
		assertTextList.add(REF_LOW);
		assertTextList.add(REF_HIGH);
		return assertTextList.iterator();
	}
	
	private LabResults createChemLabResults() {
		LabResults labResults = new LabResults();
		LabResult labResult = new LabResult();
		labResult.setResultedDate(DATE);
		labResult.setTestname(TEST_NAME);
		labResult.setValue(RESULT);
		labResult.setValueUnits(RESULT_UNIT);
		labResult.setReferenceLow(REF_LOW);
		labResult.setReferenceHigh(REF_HIGH);
		labResults.add(labResult);
		
		return labResults;
	}
}
