package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

public class AppointmentsPDFReportTest extends AbstractPDFReportTest {
	final Date DATE = DateHelper.parseDate("11/11/11");
	final String CLINIC = "Radiology Clinic South";
	final String FACILITY = "WVVAMC";
	final String NOTES = "These are the notes";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.appointment, true);
		context.setInformation(Domain.appointment, createAppointments());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.limited", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.appointments.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.appointments.date", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.appointments.clinic", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.appointments.facility", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.appointments.notes", null, locale));
		assertTextList.add(DateHelper.formatDate(DATE));
		assertTextList.add(CLINIC);
		assertTextList.add(FACILITY);
		assertTextList.add(NOTES);
		return assertTextList.iterator();
	}
	
	private Appointments createAppointments() {
		Appointments appointments = new Appointments();
		Appointment appointment = new Appointment();
		appointment.setAppointmentStartDate(DATE);
		appointment.setClinicName(CLINIC);
		appointment.setFacilityName(FACILITY);
		appointment.setClinicalNotes(NOTES);
		appointments.add(appointment);
		return appointments;
	}
}
