package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class AllergiesPDFReportTest extends AbstractPDFReportTest {
	final String SUBSTANCE = "Peanut";
	final String REACTION = "Anaphylaxis";
	final String SOURCE_SYSTEM = "VA";
	
	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.allergy, true);
		context.setInformation(Domain.allergy, createAllergies());
		
		return context;
	}
	
	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.active", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.allergies.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.allergies.allergen", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.allergies.reaction", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.allergies.source", null, locale));
		assertTextList.add(SUBSTANCE);
		assertTextList.add(REACTION);
		assertTextList.add(SOURCE_SYSTEM);
		return assertTextList.iterator();
	}
	
	private Allergies createAllergies() {
		Allergies allergies = new Allergies();
		Allergy allergy = new Allergy();
		allergy.setSubstance(SUBSTANCE);
		allergy.setReaction(REACTION);
		allergy.setSourceSystem(SOURCE_SYSTEM);
		allergies.add(allergy);
		
		return allergies;
	}
}
