package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.io.*;
import java.text.*;

import org.junit.*;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.pages.HealthAdvocateRequestPage;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.itextpdf.text.DocumentException;


public class AdvocateAuthorizationTest {
  private static final String BASE_LOCATION = "build/resources/test/pdf/";
  
  @BeforeClass
  public static void setup() throws Exception {
    new File(BASE_LOCATION).mkdirs();
  }

  @Test
  public void HealthAdvocateRequestPageTest() throws FileNotFoundException, DocumentException{
    //Document document = null;
    
    PdfGenerationContext context = new PdfGenerationContext();
    OutputStream outputStream = new FileOutputStream(BASE_LOCATION + "PopulatedForm.pdf");

    HealthAdvocateRequest request = new HealthAdvocateRequest();
    populateRequest(request);

    context.setInformation(Domain.healthAdvocateRequest, request);

    HealthAdvocateRequestPage page = new HealthAdvocateRequestPage(null, null, null, context, outputStream);
    page.create();
  }

  @Test
  public void HealthAdvocateRequestCancelledPageTest() throws FileNotFoundException, DocumentException{
    //Document document = null;
    
    PdfGenerationContext context = new PdfGenerationContext();
    OutputStream outputStream = new FileOutputStream(BASE_LOCATION + "AdvocateRequestCancelled.pdf");

    HealthAdvocateRequest request = new HealthAdvocateRequest();
    request.setStatus(HealthAdvocateStatusCode.CANCELLED);
    populateRequest(request);

    context.setInformation(Domain.healthAdvocateRequest, request);

    HealthAdvocateRequestPage page = new HealthAdvocateRequestPage(null, null, null, context, outputStream);
    page.create();
  }

  @Test
  public void HealthAdvocateRequestRevokedPageTest() throws FileNotFoundException, DocumentException{
    //Document document = null;
    
    PdfGenerationContext context = new PdfGenerationContext();
    OutputStream outputStream = new FileOutputStream(BASE_LOCATION + "AdvocateRequestRevoked.pdf");

    HealthAdvocateRequest request = new HealthAdvocateRequest();
    request.setStatus(HealthAdvocateStatusCode.REVOKED);
    populateRequest(request);

    context.setInformation(Domain.healthAdvocateRequest, request);

    HealthAdvocateRequestPage page = new HealthAdvocateRequestPage(null, null, null, context, outputStream);
    page.create();
  }

  private void populateRequest(HealthAdvocateRequest request) {
    request.setPatientName("Patient Name");
    request.setPatientDisplayName("Name, Patient");   request.setFirstName("First");
    request.setLastName("Last");
    request.setEmail("email@email.com");
    request.setDriversLicenseNumber("0987654321");
    request.setDriversLicenseState("NY");
    
    try {
      DateFormat df  = new SimpleDateFormat("M/d/yyyy");
      request.setRequestDate(df.parse("5/4/2012"));
    } catch (ParseException e) {
      e.printStackTrace();
    }
    
    request.setAddressFirstLine("Address1");
    request.setAddressSecondLine("Address2");
    request.setCity("City");
    request.setState("State");
    request.setZipCode("ZipCode");
  }
}
