package com.agilex.healthcare.mobilehealthplatform.pdf;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;

public class AdmissionsPDFReportTest extends AbstractPDFReportTest {
	final Date ADMISSION_DATE = DateHelper.parseDate("06/01/2011");
	final Date DISCHARGE_DATE = DateHelper.parseDate("07/01/2011");
	final String FACILITY = "DCVAMC";
	final String ADMITTING_PROVIDER = "Dr. Brian";
	final String DISCHARGE_SUMMARY = "Summary";

	public PdfGenerationContext specifyContext(PdfGenerationContext context) {
		context.setVisible(Domain.admission, true);
		context.setInformation(Domain.admission, createAdmissions());

		return context;
	}

	public Iterator<String> getAssertionTextIterator() {
		List<String> assertTextList = new LinkedList<String>();
		assertTextList.add(messageSource.getMessage("mbb.report.cover.toc.limited", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.admissions.title", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.admissions.admissionDate", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.admissions.dischargeDate", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.admissions.facility", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.admissions.admittingProvider", null, locale));
		assertTextList.add(messageSource.getMessage("mbb.report.admissions.dischargeSummary", null, locale));
		assertTextList.add(DateHelper.formatDate(ADMISSION_DATE));
		assertTextList.add(DateHelper.formatDate(DISCHARGE_DATE));
		assertTextList.add(FACILITY);
		assertTextList.add(ADMITTING_PROVIDER);
		assertTextList.add(DISCHARGE_SUMMARY);
		return assertTextList.iterator();
	}

	private Admissions createAdmissions() {
		Admissions admissions = new Admissions();
		Admission admission = new Admission();
		admission.setAdmissionDate(ADMISSION_DATE);
		admission.setDischargeDate(DISCHARGE_DATE);
		admission.setFacilityName(FACILITY);
		admission.setAdmittingProviderName(ADMITTING_PROVIDER);
		admission.setDischargeSummary(DISCHARGE_SUMMARY);
		admissions.add(admission);
		return admissions;
	}
}
