define([
	'Global',
	'Text!../html/templates/common/header.html'
	],
	function(Global, template) {
		var ProviderSelectView = Backbone.View.extend({
			render: function() {
				var providers = this.model,
					optionList = "<option value=\"Select\">Select</option>";

				_.each(providers, function(provider) {
					var optionName = provider.providerName;
					if (provider.personClass !== '') {
						optionName += ' (' + provider.personClass + ')';
					}
					
					optionList += "<option value=\"" + provider.providerId + "\">" + optionName + "</option>";
				});
				optionList += "<option value=\"0\">Provider that I want to see is not listed</option>";

				this.options.viewContainer
					.html(optionList)
					.selectmenu('refresh', true)
					.trigger('create');

				$('#providerContainer').removeClass('display-none');

				m.resetProviderOption();

				return this;
			}
		});
		return ProviderSelectView;
	}
);