define([
	'Global',
	'Text!../html/templates/common/header.html'
	],
	function(Global, template) {
		var NotificationsView = Backbone.View.extend({
			tagName: 'ul',
			attributes: {"data-role": "listview"},
			
			initialize: function() {
				this.template = _.template($('#notifications-template').html());
			},

			render: function() {
				var appointmentRequests = this.collection,
					$notifications = $(this.el).empty(),
					accessChanges = function(request) {
						var lastAccessDate = new Date(request.collection.lastAccessDate),
							status = request.get('status');

						if ((lastAccessDate < new Date(request.get('lastUpdatedDate'))) && (status !== 'Submitted')) {
							var ardcList = request.get('appointmentRequestDetailCode');
							if ((status !== 'Cancelled') || ((typeof ardcList !== 'undefined') && ardcList.length > 0 && !containsDetailCode(ardcList, "DETCODE8"))) {
								var changed = $('#list').jqmData('changedAR');

								changed = (changed === null || changed === undefined) ? [] : changed;
								changed.push(request.get('dataIdentifier').uniqueId);
								changed = _.uniq(changed);

								$('#list').jqmData('changedAR', changed);
								return true;
							}
						}
						return false;
					};

				appointmentRequests.each(function(appointmentRequest){
					var changedRequest = accessChanges(appointmentRequest);
					if (changedRequest !== false)
						$notifications.append(this.template(appointmentRequest.toJSON()));
				});

				if ($("li:first-child", notifications).length > 0){
					 this.options.viewContainer
					 	.html($notifications)
						.trigger('create');

					$.mobile.changePage('#notifications');
				}
				return this;
			}
		});
		return NotificationsView;
	}
);
