define([
	'Global',
	'Text!../html/templates/common/header.html'
	],
	function(Global, template) {
		var AppointmentRequestDetailsView = Backbone.View.extend({
			initialize: function() {
				this.template = _.template($('#appointment-request-details-template').html());
			},
			render: function() {
				var $container = this.options.viewContainer,
					appointmentRequest = this.model,
					hidden = '',
					statusTemplate = _.template($('#appointment-request-status-template').html());

				if (appointmentRequest.get('providerOption') === undefined || appointmentRequest.get('providerOption') === '') {
					appointmentRequest.set('providerOption', '');
					hidden = 'display-none-important';
				}
				
				$container
					.html(statusTemplate($.extend({}, appointmentRequest.toJSON())));

				if (appointmentRequest.get('status') === 'Not Booked') {
					var secondRequestMessageTemplate = _.template($('#second-request-message-template').html()),
						secondRequestInputsTemplate = _.template($('#second-request-inputs-template').html());

					$container
						.prepend(secondRequestMessageTemplate($.extend({}, appointmentRequest.toJSON(), {hidden:''})))
						.append(secondRequestInputsTemplate($.extend({}, appointmentRequest.toJSON())));
				}

				$container
					.append(this.template($.extend({}, appointmentRequest.toJSON(), {hidden: hidden})))
					.trigger('create');

				return this;
			}
		});
		return AppointmentRequestDetailsView;
	}
);