define([
	'Global',
	'Text!../html/templates/common/header.html'
	],
	function(Global, template) {
		var AppointmentListView = Backbone.View.extend({
			tagName: 'ul',
			id: 'appointment-list',
			attributes: {"data-role": 'listview', "data-divider-theme": 'a' },
			
			initialize: function() {
				this.collection.bind('add', this.add, this);
				this.collection.bind('change', this.changeItem, this);
				this.collection.bind('reset', this.render, this);
				this.template = _.template($('#appointment-list-item-template').html());
				this.headerTemplate = _.template($('#list-view-header-template').html());
			},
			
			render: function() {
				var appointments = this.collection,
					$listView = $(this.el)
									.empty()
									.append(this.headerTemplate({heading: "Appointments within next 120 days"}));
				
				appointments.each(function(appointment){
					$listView.append(this.template($.extend({}, appointment.toJSON(), {cid: appointment.cid}))); //add cid to appointmentRequest.tojson()
				});
				this.options.viewContainer
					.html($listView)
					.trigger('create');
				return this;
			}
		});
		return AppointmentListView;
	}
);
