define([
    'jQuery',
    'Underscore',
    'asyncSeries'
], function ($$, Underscore, asyncSeries) {

    /****** FUNCTIONS ******/
    function openRequestForm() {
        asyncSeries( function () {
                // When I can click the New button
                ok($('#new-request-btn').trigger('tap'),
                    "When I tap on the New Request button");
            },
            function () {

                if ($('#dismiss-notice-btn').is(':visible')) {
                    ok($('#dismiss-notice-btn').simulate('click'),
                        "And I get past the Notice ok button if it is there");
                }
            }
        );
    }


    function closeRequestForm() {
        asyncSeries(function () {
                ok($("#cancel-request").simulate("click"),
                    "When I click the Cancel button");
            },
            function(){
                ok($( "#list" ).is(":visible"),
                    "Then I am on the Requests List page");

            });

    }

    //***** TESTS *****//
    module("#908 Initial textbox for veteran user message");

    test("Find text message box", function () {
        asyncSeries(openRequestForm,
            function () {
                ok($("#initialRequestMessage").is(':visible'), "Found initial request message text field");
            }, closeRequestForm
        );


    });

    test("Verify 100 character limit for request message box", function () {
        var MAXLENGTH = 100;

        asyncSeries(openRequestForm,
            function () {
                equal($("#initialRequestMessage").attr("data-maxlength"), MAXLENGTH,
                    "Max length of " + MAXLENGTH + " verified");
            }, closeRequestForm
        );

    });

});

