define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		

	module("#528/1132 - Informational text on message count - Vet");
	
	test("#1538 Validate the informational message text on number of messages that can be sent by Patient", function() {
		asyncSeries(function(){
			if ($('#list').is(':visible')) {
			ok($("#list").is(":visible"),
			"Given I am on the Requests List page");
			}	
			return 1000;
			
		//Validate the new notification preference section
			
			}, function() {
				$('#new-request-btn').trigger('tap');
			}, function() {
				$('#dismiss-notice-btn').trigger('click');
		//New Request Form
			}, function() {
				ok($('#request-form-content').is(':visible'),'Then the New Request form is visible');
		//Validate the new informational text displayed above the message text box
			}, function() {
				ok($("#request-form-form div:nth-child(13):contains('This exchange is limited to four (4) messages. If you need additional information, please call the Clinic.')")
						.length > 0,'Info msg on new form','Informational message text exists');
				ok($("#cancel-request").trigger('click'),'Cancel from new form');
			}, function() {
				ok($("#list" ).is(":visible"),"Given I am on the Requests List page");
		//Validate informational message on existing request
				ok($("#appointment-request-list a[data-status='Not Booked']").eq(0).mousedown().click(),"When I click a Booked appointment");
				ok($("#appointment-request-details-content div:nth-child(1):contains('This exchange is limited to four (4) messages. If you need additional information, please call the Clinic.')")
						.length > 0,'Info text exists','Informational message text exists');
				});
		});
	

	module("#528/1068 - Implement VAR messaging business rules");
	
	test("#1542 Validate Business rules on limiting user from sending messages - Vet side", function() {
		asyncSeries(function(){
			if ($('#list').is(':visible')) {
			ok($("#list").is(":visible"),
			"Given I am on the Requests List page");
			}	
			return 1000;
			}, function() {
				//Validate default text displayed in the text message field

				//Click on Not Booked appointment request
				ok($("#appointment-request-list a[data-status='Not Booked']").eq(0).mousedown().click(),
					"When I click a Booked appointment");
				//Request details is displayed
			}, function() {
				ok($("#appointment-request-details").is(":visible"),
					"Then I can see its Details page");
					
				//Validate that no more than 2 responses can be sent by initiator
					
				//Click on the message text box
				$("#newMessage").find('input').eq(0).trigger('click');
				//As there is already 2 msg exchange no more msgs can be sent
			}, function() {
				ok($("#newMessage").attr("placeholder"),"Can't send more than two messages...",
					'Default text when 2 msg exchange has happened');
				//Send button is disabled
			}, function() {
				ok($("#sendMessage").attr("aria-disabled"),'Send button is disabled','Send button disabled');
				//Validate that Vet sent only 2 messages
				ok($('.sent').length >1<3,'true','2 msgs sent by vet');
					
			}, function() {
				//Go back Appointment list
				$("#appointment-request-details a[data-rel='back']").mousedown().click();
			}, function() {
				ok($("#list").is(":visible"),
					"Then I can see the Requests List page");
					
				//Validate that you have to wait for a response once a message is sent
			}, function() {	
				ok($("#appointment-request-list a[data-status='Booked']").eq(0).mousedown().click(),
					"When I click a Booked appointment");
				//Request details is displayed
			}, function() {
				ok($("#appointment-request-details").is(":visible"),
					"Then I can see its Details page");
					
				//Only 1 message is sent by vet, no msg received yet from clerk
				ok($('.sent').length <2,'Only 1msg was sent','Only 1 msg was sent');
					
				//validate msg in the text box
				$("#newMessage").find('input').eq(0).trigger('click');
			}, function() {
				ok($("#newMessage").attr("placeholder"),'Must wait for response before sending another message',
					'Default text when 2 msg exchange has happened');
				//Send button is disabled
				ok($("#sendMessage").attr("aria-disabled"),'Send button disabled','Send button disabled');
			}, function() {
				//Go back Appointment list
				$("#appointment-request-details a[data-rel='back']").mousedown().click();
			}, function() {
				ok($("#list").is(":visible"),
					"Then I can see the Requests List page");
				
					
			//Validate that no message can be sent on cancelled appointments
			}, function() {
				ok($("#appointment-request-list a[data-status='Cancelled']").eq(0).mousedown().click(),
					"When I click a Cancelled appointment");
				//Request details is displayed
			}, function() {
				ok($("#appointment-request-details").is(":visible"),
					"Then I can see its Details page");
					
				//validate msg in the text box
				
				$("#newMessage").find('input').eq(0).trigger('click');
			}, function() {
				ok($("#newMessage").attr("placeholder"),'Appointment has been cancelled',
					'Appointment cancelled');
				//Send button is disabled
			}, function() {
				ok($("#sendMessage").attr("aria-disabled"),'Send button is disabled','Send button disabled');
					
			}, function() {
				//Go back Appointment list
				$("#appointment-request-details a[data-rel='back']").mousedown().click();
			}, function() {
				ok($("#list").is(":visible"),
					"Then I can see the Requests List page");
		});
	});
});

