define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		function openRequestForm() {
			asyncSeries(function() {
				// When I can click the New button
				ok($('#new-request-btn').trigger('tap'),
				"When I tap on the New Request button");
			},
			function() {
				if ($('#dismiss-notice-btn').is(':visible')) {
					ok($('#dismiss-notice-btn').simulate('click'),
						"And I get past the Notice ok button if it is there");
				}
			});

			return 1000;
		}	

		function clickVideoConferenceRadioButton() {
			// When I click the Video Conference button
			ok($( "#ui-btn-text" ).simulate('click'),
			"When I click the Video Conference button");
		}

		function checkVideoText() {
			// Then I can see the video user12ence text
			ok($( "#videoConferenceCaveatText small:contains('Video clinics are not available in all VA clinics.  If video clinic appointments are not available, your request will be treated as a Telephone Visit request.  See the About button for more information on Video Clinic.')").text(),
			"Then I can see the video user12ence text");
		}

		function cancelNewRequestForm() {
			asyncSeries(
			function() {
				//Given I am on the Request Form
				ok($('#request-form-content').is(':visible'),
				'Then the New Request form is visible');
			},
			function() {
				//When I click the Cancel button
				ok($("#cancel-request").simulate("click"),
				"When I click the Cancel button");
			},
			function() {
				//Then I am returned to the Request List
				ok($("#list").is(":visible"),
				"Then I am returned to the Request List");
			});

			return 1000;
		}

		function openAbout() {
			
		}

		function checkVideoTextInAbout() {	
			asyncSeries(function() {
				// When I can click the About button
				ok($( "div[data-role='navbar'] a[href='#about']" ).simulate("click"),
					"When I click the About button");
			},
			function() {
				// Then I am on the About dialog
				ok($( "#about" ).is(":visible"),
				"Then I am on the About dialog");
				//Then I can see the Video Conference header text
				ok($( "#about h3:contains('Video Clinic Information')" ).is(":visible"),
				"Then I can see the Video Clinic Information header text");
				
				//Then I can see the Video Conference explanation text
				equal($( "#about h3:contains('Video Clinic Information') + p").text(), 
						"The Department of Veteran Affairs has begun to implement Video Clinics.  Not all clinics or providers currently have this capability. If the clinic/provider you request does not have Video Clinics, your request will be treated as a Telephone request.  For Video Clinics, you will need a computer (or tablet) and internet access.  You will need to download Jabber software prior to the visit.",
						"Then I can see the Video Clinic Information paragraph");
				
				ok($( "#about-ok-btn" ).simulate("click"),
				"Close about");

			});

			return 2000;
			
		}
		//***** TESTS *****//
		module("#39418 Video Info");
		
		test("videoInfoOnRequestForm", function() {
			stop();
			asyncSeries(openRequestForm, clickVideoConferenceRadioButton,
				checkVideoText, cancelNewRequestForm, start);

		});

		test("videoInfoHelpAbout", function() {
			stop();
			asyncSeries(function() {
				if ($('#dismiss-notice-btn').is(':visible')) {
					ok($('#dismiss-notice-btn').simulate('click'),
						"And I get past the Notice ok button if it is there");
					}
				// When I can click the About button
				ok($( "div[data-role='navbar'] a[href='#about']" ).simulate("click"),
					"When I click the About button");
			}, checkVideoTextInAbout, start);

		});
//		---------------------------------------------------------------------
});
