define([
	'jQuery',
	'Underscore',
	'async',
	'asyncSeries'
], function($$, Underscore, async, asyncSeries) {

		//***** FUNCTIONS ******/	
		function openRequestForm() {
			async.series([function(next) {
				ok($('#list').is(':visible'),
					'Given I am on the Requests List page');
	
				ok($('#request-form-content').is(':not(:visible)'),
					'Then the New Request form not visible');
	
				ok($('#new-request-btn').trigger('tap'),
					"When I tap on the New Request button");
				next();
			}, function(next) {
				setTimeout(function() {
					next();
				}, 500);
			}, function(next) {
				if ($('#dismiss-notice-btn').is(':visible')) {
					ok($('#dismiss-notice-btn').simulate('click'),
						"And I get past the Notice ok button if it is there");
				}
				next();
			}, function(next) {
				setTimeout(function() {
					next();
				}, 500);
			}], function() {
				ok($('#request-form-content').is(':visible'),
				'Then the New Request form is visible');
			});

			return 2000;
		}

		function leaveRequestForm() {
			asyncSeries(function() {
				ok($("#cancel-request").simulate("click"),
					"When I click the Cancel button");
			},
			function() {
				ok($("#list").is(":visible"),
					"Then I am back on the Requests List page");
			});

			return 1000;
		}

		function openAbout() {

			// When I can click the About button
			ok($( "div[data-role='navbar'] a[href='#about']" ).simulate("click"),
				"When I click the About button");

		}

		function leaveAbout() {
			asyncSeries(function() {
				ok($("about-ok-btn").simulate("click"),
					"When I click on the Ok button");
			},
			function() {
				ok($("#list").is(":visible"),
					"Then I am back on the Requests List page");
			});

			return 1000;

		}

		//***** TESTS *****//
		module("#39417 Text Messaging");

//		test("SMS permission radio buttons present", function() {
//			stop();
//			// Given I am on the Request Form
//
//			asyncSeries(openRequestForm, function() {
//
//				ok($("#prohibitTextMessaging").is(":visible"),
//				"Then the 'No' radio button is visible");
//
//				ok($("#authorizeTextMessaging").is(":visible"),
//					"Then the 'Yes' radio button is visible");
//
//			}, leaveRequestForm, start);
//
//		});
//
//		test("SMS input field present if SMS permission granted", function() {
//			stop();
//			asyncSeries(openRequestForm, function() {
//
//				ok($("#prohibitTextMessaging").simulate("click"),
//					"When I click the 'No' radio button");
//
//				ok($("#textMessagingPhoneNumber").is(":hidden"),
//					"Then I can NOT see the SMS number field");
//
//				ok($("#authorizeTextMessaging").simulate("click"),
//					"When I click the 'Yes' radio button");
//
//				ok($("#textMessagingPhoneNumber").is(":visible"),
//					"Then I CAN see the SMS number field");
//
//			}, leaveRequestForm, start);
//
//		});

		test("SMS text in About", function() {
			stop();
			asyncSeries(function() {

				// Given I am on the Requests List page
				ok($("#list").is(":visible"),
					"Given I am on the Requests List page");

				// When I click the About button
				openAbout();

			}, function() {

				ok($("#about").is(":visible"),
					"Then the About dialog is visible");

				// Then I can see the correct SMS header and text
				equal($("#about h3:contains('Cell Phone Number and Text Messages from the Department of Veteran Affairs')").text(),
					"Cell Phone Number and Text Messages from the Department of Veteran Affairs",
					"Then the SMS header is correct");

				equal($("#about h3:contains('Cell Phone Number and Text Messages from the Department of Veteran Affairs') + p").text(),
					"Your cell number is requested so that if your Department of Veteran Affairs facility provides text message alerts about appointments you can take advantage of this service.  Your information will not be shared.  Providing the information is optional. ",
					"Then the SMS text content is correct");

				// clean up
				ok($("#about-ok-btn").simulate("click"),
					"When I click on the Ok button");

			}, function() {

				ok($("#list").is(":visible"),
					"Then I am back on the Requests List page");

			}, start);

		});
});