define([
	'jquery',
	'Underscore',
	'utilities'
], function($, Underscore, utilities) {


	/*____Test Duration Calculator____*/

	test('Date Calculator produces proper date in the past',4, function() {  
		// On start this is visible  
		equal(produceDate(1, '05/21/2012') , '05/21/2011', '1 year in the past'); 
		equal(produceDate(1, '05/21/2012') , '05/21/2011', '1 year in the past, adds DD and MM');
		equal(produceDate(2, '05/21/2012') , '05/21/2010', '2 year in the past'); 
		equal(produceDate(2, '02/29/2012') , '03/01/2010', '2 year in the past, leap year');
	});

	/*____Test formatDateToDays____*/

	test('Takes date object and formats it to Month Day, Year and truncates days needed',14, function() {  
		// On start this is visible  
		equal(formatDateToDays('05/21/2012') , '<span><strong>Monday</strong></span> <span>May 21, 2012</span>', 'Monday'); 
		equal(formatDateToDays('06/21/2012') , '<span><strong>Thursday</strong></span> <span>June 21, 2012</span>', 'Thursday');
		equal(formatDateToDays('11/21/2012') , '<span><strong>Wednesday</strong></span> <span>November 21, 2012</span>', 'Wednesday'); 
		equal(formatDateToDays('08/21/2012') , '<span><strong>Tuesday</strong></span> <span>August 21, 2012</span>', 'Tuesday');
		equal(formatDateToDays('09/21/2012') , '<span><strong>Friday</strong></span> <span>September 21, 2012</span>', 'Friday');
		equal(formatDateToDays('10/21/2012') , '<span><strong>Sunday</strong></span> <span>October 21, 2012</span>', 'Sunday');
		equal(formatDateToDays('04/21/2012') , '<span><strong>Saturday</strong></span> <span>April 21, 2012</span>', 'Sat');

		equal(formatDateToDays('05/21/2012', true) , '<span><strong>Mon</strong></span> <span>May 21, 2012</span>', 'Mon'); 
		equal(formatDateToDays('06/21/2012', true) , '<span><strong>Thur</strong></span> <span>June 21, 2012</span>', 'Tue');
		equal(formatDateToDays('11/21/2012', true) , '<span><strong>Wed</strong></span> <span>November 21, 2012</span>', 'Wed'); 
		equal(formatDateToDays('08/21/2012', true) , '<span><strong>Tue</strong></span> <span>August 21, 2012</span>', 'Tue');
		equal(formatDateToDays('09/21/2012', true) , '<span><strong>Fri</strong></span> <span>September 21, 2012</span>', 'Fri');
		equal(formatDateToDays('10/21/2012', true) , '<span><strong>Sun</strong></span> <span>October 21, 2012</span>', 'Sun');
		equal(formatDateToDays('04/21/2012', true) , '<span><strong>Sat</strong></span> <span>April 21, 2012</span>', 'Sat');
	});

	/*____Test formatTime____*/

	test('Transforms 24hr time to 12hr time', function() {
		// On start this is visible  
		equal(formatTime('06/13/2012 02:01:02') , '2:01 AM', 'first 12 hrs'); 
		equal(formatTime('06/13/2012 23:01:02') , '11:01 PM', 'second 12 hrs');
	});

	/*____Test writeLocationsToStorage ____*/

	test('Write key and value to local storage', 1, function() {
		writeLocationsToStorage('test', 'me'); 
		equal(readLocationsFromStorage('test') , 'me', 'Read from local storage'); 
	});

	/* Test getUriByTitle*/

	test('Get Uri by title', 1, function() {
		var atomLinks = [{
			"rel": "self",
			"href": "http://localhost:8080/MobileHealthPlatformWeb/rest/securemessage-service/SM/71/secure-message-user",
			"object-type": "AtomLink"
		}, {
			"rel": "related",
			"title": "folders",
			"href": "http://localhost:8080/MobileHealthPlatformWeb/rest/securemessage-service/SM/71/folders",
			"object-type": "AtomLink"
		}, {
			"rel": "related",
			"title": "contacts",
			"href": "http://localhost:8080/MobileHealthPlatformWeb/rest/securemessage-service/SM/71/contacts",
			"object-type": "AtomLink"
		}, {
			"rel": "related",
			"title": "send",
			"href": "http://localhost:8080/MobileHealthPlatformWeb/rest/securemessage-service/SM/71/messages",
			"object-type": "AtomLink"
		}, {
			"rel": "related",
			"title": "save-draft",
			"href": "http://localhost:8080/MobileHealthPlatformWeb/rest/securemessage-service/SM/71/drafts/messages",
			"object-type": "AtomLink"
		}];

		equal(getUriByTitle(atomLinks, 'folders') , 'http://localhost:8080/MobileHealthPlatformWeb/rest/securemessage-service/SM/71/folders', 'Retrieving Uri for Folders'); 
	});

	test('Get Uri by title when the atomlinks are empty', 1, function() {
		var atomLinks = [];

		equal(getUriByTitle(atomLinks, 'folders') , null, 'Returns null'); 
	});
});