define([
	'jquery',
	'async'
], function(jQuery,async) {

	var $$ = jQuery.noConflict(true),
	myFrame = $$("#myFrame");

    require(['notificationPreferencesTests']);
	require(['appointmentsTests']);
	require(['utilitiesTests']);

	var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;

	async.series([
		function(next) {
			$$(document).ready(function() { next(); });
		},
		function(next) {
			myFrame.attr('src', referencePath + '../../logout')
				.one('load', function() { next(); });
		},
		function(next) {
			myFrame.attr('src', referencePath + '../../oauthlogin?redirect_uri=' + referencePath + '../../launchpad')
				.one('load', function() { next(); });
		},
		function(next) {
			//grab jQuery from inside the document
			$ = jQuery = myFrame[0].contentWindow.jQuery;

			$("#name-c").val('zztest.patient66');
			$("#password").val('pass');

			$("#logonForm").submit();
			myFrame.one('load', function() { next(); });
		}
	], function() {
		start();
	});

	QUnit.testStart(function() {
		stop();
		myFrame.attr('src', referencePath + '../../launchpad')
			.on("load", function() {
				//grab jQuery from inside the document
				$ = jQuery = myFrame[0].contentWindow.jQuery;

				//turn off async so tests will wait for ajax results
				$.ajaxSetup({ async: false });

				$.getScript(referencePath + "../jquery.simulate.js");

				//turn off animations so they do not break tests
				$.support.cssTransitions = false;
				$.fx.off = true;
				
				QUnit.start();
			});
	});
});