(function () {
	require.config({
		paths: {
			// path configuration assumes .js suffix

			// Libraries
			'jquery': '../../js/libs/jquery-1.8.2.min',
			'Underscore': '../../js/libs/underscore',
			'Backbone': '../../js/libs/backbone',
			
			'plugins': '../../js/plugins',
			'helper': '../../js/helper',
			'touchSwipe': '../../js/libs/jquery.touchSwipe-1.2.6',
			
			'events': '../../js/events',
			'vizmetro': '../../js/viz-metro',
			'datacalls': '../../js/data-calls',
			
			'utilities': '../../js/utilities',
			'models': '../../js/models',
			'appointments': '../../appointments/js/app',

            'veteran-appointment-requests': '../../veteran-appointment-requests/js/app',

            'sinon': '../../js/libs/sinon-1.5.2',
            'sinonQunit': '../../js/libs/sinon-qunit-1.0.0',
				
			'async': '../async'
		},
		shim: {
			
			'touchSwipe': {
				deps: ['jquery']
			},
			'plugins': {
				deps: ['Backbone']
			},
			'events': {
				deps: ['Backbone','helper','touchSwipe']
			},
			'helper': {
				deps: ['Backbone']
			},
			'datacalls': {
				deps: ['Backbone']
			},
			'Underscore': {
				exports: '_'
			},
			'Backbone': {
				deps: ['jquery', 'Underscore'],
				exports: 'Backbone'
			},
			'models': {
				deps: ['Backbone']
			},
			'utilities': {
				deps: ['Backbone']
			},
			'appointments': {
				deps: ['jquery','Backbone','models','datacalls','vizmetro','events','touchSwipe','helper','plugins']
			},
            'veteran-appointment-requests': {
                deps: ['jquery','Backbone','models','datacalls','vizmetro','events','touchSwipe','helper','plugins']
            },
            'sinon': {
                deps : [ 'jquery' ],
                exports: 'sinon'
            },
            'sinonQunit': {
                deps : [ 'sinon' ],
                exports: 'sinonQunit'
            },
			'async': {
				exports: 'async'
			}
		}
	});
	require(['setup']);
}());