define([
	'jquery',
	'Underscore',
	'appointments'
], function($, Underscore, appointments) {
	
	module('Tests for secondRequestDatesValid');
	var firstRequest = new m.AppointmentRequest(),
		secondRequest = new m.AppointmentRequest();

	QUnit.testStart(function() {
		firstRequest.set('optionDate1','9/7/2012');
		firstRequest.set('optionTime1', 'AM');
		firstRequest.set('optionDate2', '9/8/2012');
		firstRequest.set('optionTime2', 'AM');
		firstRequest.set('optionDate3', '9/9/2012');
		firstRequest.set('optionTime3', 'AM');

		secondRequest.set('optionDate1', firstRequest.get('optionDate1'));
		secondRequest.set('optionTime1', firstRequest.get('optionTime1'));

		secondRequest.set('optionDate2', '9/10/2012');
		secondRequest.set('optionTime2', 'AM');
		secondRequest.set('optionDate3', '9/11/2012');
		secondRequest.set('optionTime3', 'AM');
	});

	test('Ensure secondRequestDatesValid returns true when second request has no repeats', function() {
		firstRequest.set('optionDate1','9/7/2012');
		firstRequest.set('optionTime1', 'AM');
		firstRequest.set('optionDate2', '9/8/2012');
		firstRequest.set('optionTime2', 'AM');
		firstRequest.set('optionDate3', '9/9/2012');
		firstRequest.set('optionTime3', 'AM');

		secondRequest.set('optionDate1', firstRequest.get('optionDate1'));
		secondRequest.set('optionTime1', firstRequest.get('optionTime1'));

		secondRequest.set('optionDate2', '9/10/2012');
		secondRequest.set('optionTime2', 'AM');
		secondRequest.set('optionDate3', '9/11/2012');
		secondRequest.set('optionTime3', 'AM');

		ok(m.secondRequestDatesValid(firstRequest, secondRequest),
			'Appropriate dates are different');
	});

	test('Ensure secondRequestDatesValid returns false when option1 is different', function() {
		secondRequest.set('optionDate1', '9/12/2012');
		secondRequest.set('optionTime1', firstRequest.get('optionTime1'));
		equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
			'Option1 calendar dates are different');

		secondRequest.set('optionDate1', firstRequest.get('optionDate1'));
		secondRequest.set('optionTime1', 'PM');
		equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
			'Option1 times of day(am/pm) are different');
	});

	test('Ensure secondRequestDatesValid returns false when second request has a repeat', function() {
		secondRequest.set('optionDate2', firstRequest.get('optionDate1'));
		secondRequest.set('optionTime2', firstRequest.get('optionTime1'));
		equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
			'Second request option2 is a direct repeat of first request option1');

		secondRequest.set('optionDate3', firstRequest.get('optionDate2'));
		secondRequest.set('optionTime3', firstRequest.get('optionTime2'));
		equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
			'Second request option3 is a direct repeat of first request option2');
	});

	test('Ensure secondRequestDatesValid returns true when second has repeat date but not time', function() {
		secondRequest.set('optionDate2', firstRequest.get('optionDate2'));
		secondRequest.set('optionTime2', 'PM');
		ok(m.secondRequestDatesValid(firstRequest, secondRequest),
			'Second request optionDate2 is a repeat of first request optionDate2');

		firstRequest.set('optionTime3', 'PM');
		secondRequest.set('optionDate3', firstRequest.get('optionDate3'));
		ok(m.secondRequestDatesValid(firstRequest, secondRequest),
			'Second request optionDate3 is a repeat of first request optionDate3');
	});
});