define([
	'jQuery'
], function($$) {
	var defineTests = function() {

		module("#39630 Convert SoC to jQM/Backbone");
			
		function getAge(year, month) {
			var today = new Date();
			var birthDate = new Date(year, month, 1);
			var age = today.getFullYear() - birthDate.getFullYear();
			var m = today.getMonth() - birthDate.getMonth();
			if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
				age--;
			}
			return age;
		}

		test('Verify the format of the DOB and age calculation', function() {
			var dob = 'Feb 1985';
			var age = getAge(1985, 2);
			equal($('#summary-Contact-Information [name="dob"]').text(), dob + ' (' + age + ')', 'Verify the format of DOB and calculated age');
		});

	};
	
	return {
		initialize: defineTests
	};
});
