define([
	'jQuery',
	'async',
	'common',
	'../modules/39630',
	'../modules/36919',
	'37385',
	'../modules/37175',
	'../modules/37353',
	'../modules/36933',
	'36982',
	'../modules/39949',
	'40080',
	'../modules/36961',
	'../modules/36948',
	'40151',
	'40056'
	
], function(jQuery, async, commonTests, SoCTests, labGrouping, clinicalNotes, 
		/*microbiology,*/ labResults, vitalSigns, labGraph, radiology, vitalsGraph, footer, 
		medications, labGraphDateRanges, timeSortGraphs, checkEULA) {

	var $$ = jQuery.noConflict(true),
	myFrame = $$("#myFrame");
	
	var setup = function() {
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
		defineTests();

		async.series([
			function(next) {
				$$(document).ready(function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '../../logout')
					.one('load', function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '../../oauthlogin?redirect_uri=' + referencePath + '../../summaryofcare')
					.one('load', function() { next(); });
			},
			function(next) {
				afterJqueryLoad(function() {
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					$("#name-c").val('zztest.patient66');
					$("#password").val('pass');

					$("#logonForm").submit();
					myFrame.one('load', function() {
						afterJqueryLoad(function () {
							afterOauthTokenInSessionStorage(function() {
								next();
							});
						});
					});
				});
			}
		], function() {
			start();
		});

		QUnit.testStart(function() {
			stop();
			myFrame.off("load");
			myFrame.attr('src', referencePath + '../../summaryofcare')
				.on("load", function() {
					afterJqueryLoad(function() {
						var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
						
						//grab jQuery from inside the document
						$ = jQuery = myFrame[0].contentWindow.jQuery;

						//turn off async so tests will wait for ajax results
						$.ajaxSetup({ async: false });

						$.getScript(referencePath + "../jquery.simulate.js");

						//turn off animations so they do not break tests
						$.support.cssTransitions = false;
						$.fx.off = true;
						
						var started = false;
						$(myFrame[0].contentWindow.document).ready(function () {
							setTimeout(function() {
								if (!started) {
									started = true;
									QUnit.start();
								}
								
							}, 1000);
						});
						
						setTimeout(function() {
							if (!started) {
								started = true;
								QUnit.start();
							}
						}, 5000);
					});
				});
		});

	};
	
	function afterJqueryLoad(callback) {
		if (typeof myFrame[0].contentWindow.jQuery === 'undefined') {
			setTimeout(function() {
				afterJqueryLoad(callback);
			}, 200);
		} else {
			callback();
		}
	}
	
	function afterOauthTokenInSessionStorage(callback) {
		var token = myFrame[0].contentWindow.sessionStorage.token;
		if (typeof token !== 'undefined' && token && token !== 'null') {
			callback();
		} else {
			setTimeout(function() {
				afterOauthTokenInSessionStorage(callback);
			}, 200);
		}
	}

	function defineTests() {
		commonTests.initialize();
		SoCTests.initialize();
		labGrouping.initialize();
		clinicalNotes.initialize();
//		microbiology.initialize();
		labResults.initialize();
		vitalSigns.initialize();
		labGraph.initialize();
		radiology.initialize();
		vitalsGraph.initialize();
		footer.initialize();
		medications.initialize();
		labGraphDateRanges.initialize();
		timeSortGraphs.initialize();
		checkEULA.initialize();
	}
	
	return {
		initialize: setup
	};
});
