define([
	'jQuery',
	'asyncSeries'
], function($$, asyncSeries) {
	var defineTests = function() {

		module("#40151 Chronological view of labs");
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-lab-results-btn').trigger('tap');
			
			return 500;
		}
		
		function getLabListLength()
		{
			return $('#lab-results-section li').length;
		}

		function validateDateRange(range)
		{
			//clear time
			range.setHours(0);
			range.setMinutes(0);
			range.setSeconds(0);
			range.setMilliseconds(0);
			
			var labListLength = getLabListLength();
			
			if (labListLength > 0){
				for(var i = 2; i <= labListLength; i++){
					var labDate = new Date($('#lab-results-section li:nth-child(' + i + ') b').eq(0).text());
					ok(labDate.getTime() >= range.getTime(), 'Verify the labs are within the selected date range');
				}
			} else {
				ok($('p.error-message').text(), 'No Data Found Within the Specified Date Range');
			}
		}
		
		function searchAndSelectPatient(name)
		{
			//This method is used by patient viewer to search and select a patient before proceeding
			if(window.location.href.indexOf('patient-viewer'))
			{
				if(typeof name === 'undefined')
				{
					name = 'patient66';
				}

				$('#patient-search input').val(name).trigger('change');
				$('#patient-search-results li:nth-child(2) a').trigger('tap');
			}
		}
		
		test('Verify date range options', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() {
				var oneMonth = $('#lab-list li:nth-child(1) h3').text();
				var sixMonths = $('#lab-list li:nth-child(2) h3').text();
				var oneYear = $('#lab-list li:nth-child(3) h3').text();
				var twoYears = $('#lab-list li:nth-child(4) h3').text();
				var custom = $('#lab-list li:nth-child(5) h3').text();
				
				equal(oneMonth, '1 Month', 'Verify the 1 month interval exists');
				equal(sixMonths, '6 Months', 'Verify the 6 month interval exists');
				equal(oneYear, '1 Year', 'Verify the 1 year interval exists');
				equal(twoYears, '2 Years', 'Verify the 2 year interval exists');
				equal(custom, 'Add Custom Range', 'Verify the custom interval exists');
			});
				
		});
		
		test('Verify one month filter', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() {
				$('#lab-list li:nth-child(1) a').trigger('tap');
				ok($('#lab-list li:nth-child(1).ui-btn-active').length === 1,
						'Verify that the button is active after clicking it');
				
				var range = new Date();
				range.setMonth(range.getMonth() -1);
				validateDateRange(range);
			});
		});
		
		test('Verify 6 month filter', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() {
				$('#lab-list li:nth-child(2) a').trigger('tap');
				ok($('#lab-list li:nth-child(2).ui-btn-active').length === 1,
						'Verify that the button is active after clicking it');
				
				var range = new Date();
				range.setMonth(range.getMonth() -6);
				validateDateRange(range);
			});
		});

		test('Verify 1 year filter', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() {
				$('#lab-list li:nth-child(3) a').trigger('tap');
				ok($('#lab-list li:nth-child(3).ui-btn-active').length === 1,
						'Verify that the button is active after clicking it');
				
				var range = new Date();
				range.setFullYear(range.getFullYear() -1);
				validateDateRange(range);
			});
		});
		
		test('Verify 2 year filter and that the content is scrollable', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() {
				$('#lab-list li:nth-child(4) a').trigger('tap');
				ok($('#lab-list li:nth-child(4).ui-btn-active').length === 1,
						'Verify that the button is active after clicking it');
				
				var range = new Date();
				range.setFullYear(range.getFullYear() -2);
				validateDateRange(range);
				
				ok($('#content-primary .scrollable').length === 1,
						'Verify the lab list is scrollable');
			});
		});
		
		test('Verify the custom date range filter', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() { 
				$('#lab-list li:nth-child(5) a').trigger('tap');

				
				$('#date-from').val('09/01/2012').trigger('change');
				$('#date-to').val('01/01/2013').trigger('change');
				$('#add-custom-date').trigger('tap');
			}, function() {
				$('#lab-list li:nth-child(5) a').trigger('tap');
				var range = new Date('09/01/2012');
				range.setMonth(range.getMonth() -3);
				validateDateRange(range);

			});
		});
		
		test('Verify that dates under 6 years can be selected for custom durations', function(){
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() { 
				$('#lab-list li:nth-child(5) a').trigger('tap');

				$('#date-from').val('12/10/2006').trigger('change');
				$('#date-to').val('11/10/2012').trigger('change');
				$('#date-from').datebox('open');
				equal($('.ui-datebox-griddate-disable').length, 0, 'Verify that all days under 6 years are enabled');
				$('.ui-datebox-container a').trigger('click');
				$('#custom-date-menu a').trigger('click');
			});
		});
		
		test('Verify reverse-chronological sorting', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
				$('#lab-list li:nth-child(3) a').trigger('tap');

			}, function() {
				var labListLength = getLabListLength();
				var previousDate;
				ok(labListLength > 0, 'Verify that the list contains labs');
				if(labListLength > 0){
					previousLabDate = new Date($('#lab-results-section li:nth-child(2) b').eq(0).text());
				
					for(var i = 2; i <= labListLength; i++){
						var labDate = new Date($('#lab-results-section li:nth-child(' + i + ') b').eq(0).text());
						ok(labDate <= previousLabDate, 'Verify the labs are sorted reverse-chronologically');
						previousLabDate = labDate;
					}
				}				
			});
				
		});
		
		test('Verify content headings for lab results', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() { 
				$('#tabView li:nth-child(2) a').trigger('tap');
			}, function() {
				$('#lab-list li:nth-child(4) a').trigger('tap');
			}, function() {
				
				var result = $('#lab-results-section li:nth-child(2) table th:nth-child(1)').text();
				var reference = $('#lab-results-section li:nth-child(2) table th:nth-child(2)').text();
				var status = $('#lab-results-section li:nth-child(2) table th:nth-child(3)').text();
				var facility = $('#lab-results-section li:nth-child(2) label:eq(1)').text();
				var addResults = $('#lab-results-section li:nth-child(2) label:eq(2)').contents(':not(b)').text();
				
				equal(facility, 'Facility: no data found', 'Verify the facility for the lab result');
				equal(result, 'Result', 'Verify the result heading');
				equal(reference, 'Reference Range', 'Verify the result heading');
				equal(status, 'Status', 'Verify the result heading');
				equal(addResults, 'Additional Information:', 'Verify the label for additional information');
				
			});
		});
		
		test('Verify the i button content', function() {
			asyncSeries(searchAndSelectPatient, clickFooter, function() {
				$('#lab-i-btn').trigger('tap'); 
			}, function() {
				var graph = $('#lab-results-info li:nth-child(1) h3').text();
				var time = $('#lab-results-info li:nth-child(2) h3').text();
				var labResults = $('#lab-results-info li:nth-child(3) h3').text();
				
				equal(graph, 'Graph', 'Verify the graph section is displayed');
				equal(time, 'Time', 'Verify the time section is displayed');
				equal(labResults, 'About Lab Results', 'Verify the graph section is displayed');
				
				var okBtn = $('#lab-i-ok-btn a');
				okBtn.trigger('click');
			}, function() {
				equal($('#content-secondary .ui-title ').text(), 'Lab Results',
						'Verify closing the info pop-up returnst to the lab results');
				
				//click the i window and close using the X
				$('#lab-i-btn').trigger('tap');
			}, function() {
				var xButton = $('#lab-results-info a');
				xButton.trigger('click');
				return 2000;
			}, function() {
				equal($('#content-secondary .ui-title ').text(), 'Lab Results',
					'Verify closing the info pop-up returnst to the lab results');
			});
		});
		
		
	};
	
	return {
		initialize: defineTests
	};
});
