define([
	'jQuery',
	'testUtilities'
], function($$, testUtilities) {
	var defineTests = function() {

		module("#40080 Dynamic Footer Validation");
		
		test('A fixed set of buttons is displayed', function() {
			searchPatient();
			equal($('#footer .ui-grid-d li').length, '5', 'Verify only 5 buttons are displayed');
			ok($('#footer-menu-popup-popup li').length >= 3, 'Verify the list in the popup is populated');
		});
		
		test('Verify that the popup is displayed only after clicking more', function() {
			searchPatient();
			ok($('#footer-menu-popup-popup.ui-selectmenu-hidden'), 'The popup is hidden');
			$('#footer-more-btn').trigger('tap'); 
			ok($('#footer-menu-popup-popup.ui-popup-active'), 'The popup is displayed');
			
			$('#footer-lab-results-btn').trigger('tap');
			stop();
			setTimeout(function() {
				start();
				ok($('#footer-menu-popup-popup.ui-selectmenu-hidden'), 
						'The popup is hidden after selecting clicking the footer');
			}, 100);
		});

		
	};
	
	return {
		initialize: defineTests
	};
});
