define([
	'jQuery',
	'asyncSeries',
	'App'
], function($$, asyncSeries, App) {
	var defineTests = function() {
		module("#40056 EULA Agreement");

		//***** TESTS ******//

		test('EULA Opens', function() {
			asyncSeries(triggerEULA, function() {
				ok($('.ui-dialog .ui-header h2.ui-title'),
				'End User License Agreement');
			});
		});


		//TODO: This test is hanging.  Un-comment when the decline button error is resolved 
		test('Declining EULA sends me to Launchpad', function(){
			QUnit.stop(2);
			expect(2);
			async.series([
				function(next){
					triggerEULA();
					setTimeout(next, 500);
				}, function(next) {					
					$('#eula').animationComplete(function() {
						next();
					});
				},
				function(next){
					ok($('#decline-btn').is(':visible'), 'Decline button is visible');

					var myFrame = $$('#myFrame');
					myFrame.one('load', function() {
						$ = jQuery = myFrame[0].contentWindow.jQuery;
						next();
					});
					clickDecline();
				},
				function(next){
					equal($("#header h1").text(), "Launchpad", "Then I can see the Launchpad");
					next();
				}
			], function () {
				start();
			});
		});

		test('Accepting EULA adds storage', function() {
			asyncSeries(triggerEULA, function() {
				ok($('#accept-btn').is(':visible'),
				'Accept button is visible');
			}, clickAccept, function() {
				ok(window.localStorage['/MobileHealthPlatformWeb/summaryofcare/eula'],
					'Eula was saved to local-storage');
			});
		});

		test('Accepting EULA closes dialog', function() {
			asyncSeries(triggerEULA, function() {
				ok($('#accept-btn').is(':visible'),
				'Accept button is visible');
			}, clickAccept, function() {
				equal($(".content-primary .ui-header h3").text(), App.defineResourceTitles().title,
					"Then I can see the title of the app - " + App.defineResourceTitles().title);
			});
		});

		//***** FUNCTIONS ******//

		function clickDecline() {
			$('#decline-btn').trigger('tap');
		}

		function clickAccept() {
			$('#accept-btn').trigger('tap');
			return 500;
		}

		function triggerEULA() {
			var key = '/MobileHealthPlatformWeb/summaryofcare/eula',
			testFrame = window.frames[0],
			acceptedDate = testFrame.localStorage[key];

			if (typeof acceptedDate !== 'undefined') {
				testFrame.localStorage.removeItem(key);
				window.frames[0].location = testFrame.location.origin+testFrame.location.pathname + '#eula';
			}
		}
	};

	return {
		initialize: defineTests
	};
});
