define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#37385 Clinical Notes");

		var goToClinicalEvents = function() {
			$('#footer-clinical-events-btn').trigger('tap');
			waitForElementText($('#content-secondary [data-role="header"] h3').text(), 'Clinic Events');
			
			return 500;
		};
		
		test('Verify section can be expanded and collapsed', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				ok($('#content-secondary h3').text(), "Verify the test is viewing Clinical Events");

				if(!$('#clinical-event-list div:nth-child(1) h2').hasClass('ui-collapsible-heading-collapsed'))
				{
					$('#clinical-event-list div:nth-child(1) h2 a').trigger('click');
				}
			}, function() {
				ok($('#clinical-event-list div:nth-child(1) h2').hasClass('ui-collapsible-heading-collapsed'), 'Verify that the group is collapsed');
				$('#clinical-event-list div:nth-child(1) h2 a').trigger('click');
			}, function() {
				ok(!$('#clinical-event-list div:nth-child(1) h2').hasClass('ui-collapsible-heading-collapsed'), 'Verify that the group is expanded');
			});
		});

		test('Verify the format of the past appointments metadata pane', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				ok($('#content-secondary h3').text(), "Verify the test is viewing Clinical Events");
				//Tap one of the past appointments to generate the content in the detail pane
				$('#clinical-event-list div:nth-child(1) li:nth-child(3) a').trigger('tap');
			}, function() {
				equal($('.detail-prime h3').text(), 'Radiology Clinic North', 'Verify the clinic name is displayed');
				equal($('.detail-prime p span').eq(0).text(), 'WVVAMC', 'Verify the facility name is displayed');
				equal($('.detail-prime p span').eq(1).text(), '01/04/2012, 10:00 AM', 'Verify the format of the date and time');
				equal($('.detail-prime p span').eq(2).text(), 'Provider One', 'Verify the provider name is displayed');
				equal($('.detail-prime p span').eq(3).text(), 'Radiology', 'Verify the clinic type is displayed');
				equal($('.detail-prime p').eq(4).text(), 
						'The information displayed may not reflect data from the past 2 weeks.',
						'Verify the message for events within 2 weeks');
				ok($(".detail-findings pre:contains('PRIMARY CARE VISIT')"), 'Verify that the note contains some text');
			});
		});

		test('Verify the format of the hospitalizations metadata pane', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				ok($('#content-secondary h3').text(), "Verify the test is viewing Clinical Events");

				//Tap one of the past appointments to generate the content in the detail pane
				$('#clinical-event-list div:nth-child(2) li:nth-child(3) a').trigger('tap');
			}, function() {
				equal($('.detail-prime h3').text(), 'CAVAMC', 'Verify the facility name is displayed');
				equal($('.detail-prime p label').eq(0).text().trim(), 'Admission date:', 'Verify the label for admission date');
				equal($('.detail-prime p span').eq(0).text(), '04/01/2012', 'Verify that the admission date is populated');
				equal($('.detail-prime p label').eq(1).text().trim(), 'Discharge Date:', 'Verify the label for discharge date');
				equal($('.detail-prime p span').eq(1).text(), '04/03/2012', 'Verify that the discharge date is populated');
				equal($('.detail-prime p label').eq(2).text().trim(), 'Admitting Provider:', 'Verify the label for provider');
				equal($('.detail-prime p span').eq(2).text(), 'Dr.      ', 'Verify that the provider is populated');
				ok($(".detail-findings pre:contains('DISCHARGE DIAGNOSIS')"), 'Verify that the discharge notes contain some text');
			});
		});

		test('Verify the appointments text in the navigation pane', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				var clinicAndFacility = $('#pastAppointments li:nth-child(1) h3').text();
				var dateAndTime = $('#pastAppointments li:nth-child(1) p').text();
				equal(clinicAndFacility, 'Test Clinic, DCVAMC', 'Verify the clinic and facility name is displayed');
				equal(dateAndTime, '06/02/2012, 9:00 AM', 'Verify the date and time is listed in the nav pane');
			});

		});

		test('Verify the hospitalization text in the navigation pane', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				var facilityName = $('#hospitalizations li:nth-child(1) h3').text();
				var hospitalStay = $('#hospitalizations li:nth-child(1) p').text();
				equal(facilityName, 'DCVAMC', 'Verify the facility name is displayed in the nav pane');
				equal(hospitalStay, '07/12/2012 - 07/12/2012', 'Verify the admit and discharge dates are listed in the nav pane');
			});
		});
		
		test('Handle the case where no appointment notes are available', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				//Tap one of the past appointments to generate the content in the detail pane
				$('#clinical-event-list div:nth-child(1) li:nth-child(1) a').trigger('tap');
			}, function() {
				equal($('.detail-findings span').text(), 
						'Currently no note is associated with this event.', 
				'Verify thet text for notes when none exist');
			});
		});
		
		test('Handle the case where no discharge notes are available', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				//Tap one of the past appointments to generate the content in the detail pane
				$('#clinical-event-list div:nth-child(2) li:nth-child(2) a').trigger('tap');
				return 500;
			}, function() {
				equal($('.detail-findings span').text(), 
						'Currently no note is associated with this event.', 
				'Verify thet text for hospitalizations when none exist');
			});
		});
		
		test('Past appointments should be sorted in revers chronological order', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				var appointmentLength = $('#pastAppointments li').length;
				ok(appointmentLength > 0, 'Patient has at least one appointment');
					
				var previousDate = new Date($('#pastAppointments li:nth-child(1) a p').text().substring(0,10));
				for (var i = 1; i <= appointmentLength; i ++) {
					var appDate = new Date($('#pastAppointments li:nth-child(' + i + ') a p').text().substring(0,10));
						
					ok(previousDate >= appDate, 'Previous date is greater than or equal to current date (reverse chronological order)');
					previousDate = appDate;
				}
				return 500;
			});
		});
		
		
		test('Past hospitalizations should be sorted in revers chronological order', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				var hospitalListLength = $('#hospitalizations li').length;
				ok(hospitalListLength > 0, 'Patient has at least one hospitalization');
					
				var previousDate = new Date($('#hospitalizations li:nth-child(1) a p').text().substring(13));
				for (var i = 1; i <= hospitalListLength; i ++) {
					var appDate = new Date($('#hospitalizations li:nth-child(' + i + ') a p').text().substring(13));
						
					ok(previousDate >= appDate, 'Previous date is greater than or equal to current date (reverse chronological order)');
					previousDate = appDate;
				}
				return 500;
			});
		});
		
		test('Verify the Clinical Event section headings', function() {
			searchAndSelectPatient();
			asyncSeries(goToClinicalEvents, function() {
				var appointments = $('#clinical-event-list div:nth-child(1) h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();
				var hospitalizations = $('#clinical-event-list div:nth-child(2) h2 .ui-btn-text').contents(':not(.ui-collapsible-heading-status)').text();

				equal(appointments, 'Past Kept Appointments (5)', 'Verify the button text for appointments');
				equal(hospitalizations, 'Hospitalizations (10)', 'Verify the button text for hospitalizations');
			});
		});
	};
	
	
	
	return {
		initialize: defineTests
	};
});
