define([
	'jQuery',
	'async',
	'asyncSeries',
	'testUtilities'
], function($$, async, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#36982 Detailed Radiology View");
		
		function sortRecent()
		{
			$('#tabView li:nth-child(1) a').trigger('click');
			$('#tabView li:nth-child(1) a').trigger('tap');
			ok($('#tabView li:nth-child(1) .ui-btn-active'), 'Sort by Most Recent is selected');
		}
		
		function sortAlpha()
		{
			$('#tabView li:nth-child(2) a').trigger('click');
			$('#tabView li:nth-child(2) a').trigger('tap');
			ok($('#tabView li:nth-child(2) .ui-btn-active'), 'Sort Alphabetically is selected');
		}
		
		function clickFooter()
		{
			$('#footer-more-btn').trigger('tap'); 
			$('#footer-radiology-btn').trigger('tap');
		}

		test('Verify the content pane is empty upon the initial load', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				equal($('#content-primary [data-content-theme="c"]').children().length, 0,
				'Content pane should be empty');
			});
		});		
		
		test('Verify alphabetical sort order for radiology results when grouped', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				sortAlpha();
			}, function() {
				var labLength = $('#radiology-list').children().length;
				ok(labLength > 0, 'Radiology lab results is not empty');
				
				var labName = $('#radiology-list div:nth-child(1) h2 .ui-btn-text')
								.contents(':not(.ui-collapsible-heading-status)').text();
				
				for (var i = 1; i <= labLength; i ++) {
					var nextLabName = $('#radiology-list div:nth-child('+ i +') h2 .ui-btn-text')
										.contents(':not(.ui-collapsible-heading-status)').text();
					
					ok(labName <= nextLabName, 'Verify the lab is sorted correctly');
					labName = nextLabName;
				}
			});
		});

		test('Verify reverse-chronological sorting of results when sorted by most recent', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				sortRecent();
			}, function() {
				var labLength = $('#radiology-list li').length;
				ok(labLength > 0, 'Radiology lab results is not empty');

				var previousDate = new Date($('#radiology-list li:nth-child(1) p').text());

				for (var i = 1; i <= labLength; i ++) {
					var labDate = new Date($('#radiology-list li:nth-child('+ i +') p').text()); 
						
					ok(previousDate >= labDate, 'Previous date is greater than or equal to current date (reverse chronological order)');
					previousDate = labDate;
				}
			});
		});
		
		
		test('Verify reverse-chronological sorting of results within a group', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				sortAlpha();
			}, function() {
				var labLength = $('#radiology-list').children().length;
				ok(labLength > 0, 'Radiology lab results is not empty');
				
				for (var i = 0; i < labLength; i ++) {
					var labListLength = $('#radiology-list ul').eq(i).find('li').length;
					var previousDate = new Date($('#radiology-list ul').eq(i).find('li').eq(0).find('p').text());
					
					for (var j = 0; j < labListLength; j ++) {
						var labDate = new Date($('#radiology-list ul').eq(i).find('li').eq(j).find('p').text()); 
						
						ok(previousDate >= labDate, 'Previous date is greater than or equal to current date (reverse chronological order)');
						previousDate = labDate;

					}
				}
			});
		});

		test('Verify the lab results are collapsed and no content is displayed by default', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				sortAlpha();
			}, function() {
				var labLength = $('#radiology-list').children().length;
				var collapsedSections = $('#radiology-list .ui-collapsible-collapsed').length; 
				var contentPaneLength = $('legend').length;
				equal(labLength, collapsedSections, 
						'Verify that all sections are collapsed by default');
						
				equal(contentPaneLength, 0, 'Verify that no content is displayed');
				
				//expand one of the groups
				$('#radiology-list').children().eq(2).find('a').trigger('click');
				collapsedSections = $('#radiology-list .ui-collapsible-collapsed').length;
				equal(labLength - 1, collapsedSections, 
				'Verify there is one less collapsed group');
			});
		});

		test('Verify the lab results are grouped and display the number of results within the group', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				sortAlpha();
			}, function() {
				var labName = $('#radiology-list div:nth-child(4) h2 .ui-btn-text')
				.contents(':not(.ui-collapsible-heading-status)').text();
			
				equal(labName, 'Chest X-Ray PA and Lateral (15)', 
					'Verify the labs are grouped together and their count is displaye');

			});
		});
		
		test('Verify individual radiology result button contains the facility and date', function() {
			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				sortAlpha();
			}, function() {
				var facilityName = $('#radiology-list ul').eq(1).find('li').eq(0).find('h3').text();
				var date = $('#radiology-list ul').eq(1).find('li').eq(0).find('p').text();
				
				equal(facilityName, 'SDVAMC', 'Verify that the facility is listed on the result');
				equal(date, '08/05/2008', 'Verify that the date is listed on the result');
			});
		});
		
		test('Verify the meta data for the radiology results is displayed correctly', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
				return 500;
			}, function() {
				sortAlpha();
			}, function() {
				$('#radiology-list ul').eq(3).find('li:nth-child(1) a').trigger('tap');
				
				var examType = $('.detail-prime legend').text().trim();
				
				var dateLabel = $('.detail-prime fieldset p label').eq(0).text().trim();
				var dateValue = $('.detail-prime fieldset p span').eq(0).text().trim();
				
				var facilityLabel = $('.detail-prime fieldset p label').eq(1).text().trim();
				var facilityValue = $('.detail-prime fieldset p span').eq(1).text().trim();

				var SummaryLabel = $('.detail-prime fieldset p label').eq(2).text().trim();
				var SummaryValue = $('.detail-prime fieldset p span').eq(2).text().trim();
				
				equal(examType, 'Chest X-Ray PA and Lateral', 
						'Verify the exam type is listed in the meta data of results');
				
				equal(dateLabel, 'Exam Date:',
						'Verify the exam type is listed in the meta data of results');
				equal(dateValue, '06/01/2012',
						'Verify the exam type is listed in the meta data of results');
				
				equal(facilityLabel, 'Facility:', 
						'Verify the exam type is listed in the meta data of results');
				equal(facilityValue, 'DCVAMC', 
						'Verify the exam type is listed in the meta data of results');
				
				equal(SummaryLabel, 'Summary:',
						'Verify the exam type is listed in the meta data of results');
				equal(SummaryValue, 'Normal Chest',
						'Verify the exam type is listed in the meta data of results');
			});
		});
		
		test('Verify the content of the report is populated', function() {

			asyncSeries(function() {
				searchAndSelectPatient();
			}, function() {
				clickFooter();
			}, function() {
				sortAlpha();
				return 200;
			}, function() {
				$('#radiology-list ul').eq(3).find('li:nth-child(2) a').trigger('tap');
				return 500;
			}, function() {	
				var legend = $('.detail-findings legend').text().trim();
				equal(legend, 'Radiology Report', 'Verify the heading of the report');
				
				ok($(".detail-findings pre:contains('ECHOGRAM ABDOMEN LTD')").length, 
						'Verify that the report contains some content');

			});
		});
		
	};
	
	return {
		initialize: defineTests
	};
});
