define([
	'jQuery', 'sinon', 'sinonQunit'
], function($$, sinon, sinonQunit) {
	var defineTests = function() {

		module("#39624 Sinon Proof of Concept");

		function getUniqueString()
		{
			return 'abc';
		}
	    
		//this works but the date stamp is invalid: 01/01/1970
		test('Verify the mock time feature in sinon', function() {
			ok(5 == 5, "sanity check");

			var today = new Date();
			equal(0, today.getTime(), "getTime sanity check");
		});

		//this works but the date stamp is invalid: 12/31/1969
		test('Verify the mock time feature in sinon with tick', function() {
			ok(5 == 5, "sanity check");
			this.clock.restore();
			var currentTime = new Date().getTime();
			this.clock = sinon.useFakeTimers(currentTime, "setTimeout", "clearTimeout",
					"setInterval", "clearInterval", "Date");
			var immediate = new Date();
			this.clock.tick(99999999999);
			var today = new Date();
			this.clock.tick(99999999999);
			var tomorrow = new Date();
			ok(today < tomorrow,'verify that tomorrow is greater than today');
			ok(immediate < today, 'verify that the now works');
			this.clock.restore();

		});
		
		
		test('using spies', function() {
			var spy = sinon.spy();
			spy();
			
			ok(spy.called);
			ok(spy.calledOnce);

		});
		
		test("Some timing stuff", function () {
		    var spy = this.spy();
		    setTimeout(spy, 150);

		    this.clock.tick(149);
		    ok(!spy.called);

		    this.clock.tick(1);
		    ok(spy.called);
		});

		test("should make request", function () {
		    var server = this.sandbox.useFakeServer();
		    
		    server.respondWith("GET", "/some/article/comments.json",
                    [200, { "Content-Type": "application/json" },
                     '[{ "id": 12, "comment": "Hey there" }]']);
		    
		    server.respond();
		    
		    equal(1, server.responses.length);
		    
		});
		
		module("#39624 Sinon Fake Server Proof of Concept", {
			setup: function () {
		        this.server = sinon.fakeServer.create();
		        this.server.autoRespond = true;
		        this.server.respondWith("GET", "/something", [200, { "Content-Type": "application/json" }, '{ "something": "is", "awesome": "in here" }']);
				
				this.server.respondWith("GET", "/something2", [200, { "Content-Type": "application/json" }, '{ "something2": "is", "awesome": "in here" }']);
		    },
		    teardown: function () {
		        this.server.restore();
		    }
		});
		
		test("fake server", function () {
			$$.ajax({
				url: "/something",
				success: function(data) {
					console.log(data);
				},
				error: function(err) {
					console.log(err);
				}
			});

			$$.ajax({
				url: "/something2",
				success: function(data) {
					console.log(data);
				},
				error: function(err) {
					console.log(err);
				}
			});
			
			ok(this.server.requests.length === 2);
		});
	
	};
	
	return {
		initialize: defineTests
	};
});
