define([
	'jQuery'
], function($$) {
	var defineTests = function() {

		module("#39804 Send saved draft");
		
		test('Save a draft message and then send that draft', function() {
			//Navigate from the inbox, get the number of messages sent and end in the Drafts folder
			$('#Folders-btn').trigger('tap');
			$('#folder-list li:nth-child(2) a').trigger('tap');
			var sentMsgCount = $('#inbox-list li').size();
			$('#Folders-btn').trigger('tap');
			$('#folder-list li:nth-child(3) a').trigger('tap');

			//Create the new message
			$('#primary-new-btn').trigger('tap');
			$('#new-subject-line').val("This is a test subject");
			$('#new-body').val("This is a test message body");
			$('#new-actions-btn').trigger('tap');
			$('#draft-menu li:nth-child(2) a').trigger('tap');

			//Validate that the draft is saved
			$('#inbox-list li:contains("This is a test subject") a').trigger('tap');
			$('#primary-reply-btn').trigger('tap');
			ok($('#new-send-btn').attr("class").search('ui-disabled'), 'Verify the send button is disabled');
			
			//Modify the message 
			$('#new-body').val("This is a revised test message body");
			$('#new-body').trigger('keyup');
			ok($('#new-send-btn').attr("class").search('ui-disabled') < 0, 'Verify the send button is enabled');
			$('#new-send-btn').trigger('tap');
			$('#Folders-btn').trigger('tap');
			$('#folder-list li:nth-child(2) a').trigger('tap');
			equal(sentMsgCount + 1, $('#inbox-list li').size(), 'Verify the draft message was added to the Sent folder');
		});
			

	};
	
	return {
		initialize: defineTests
	};
});
