define([
	'jQuery'
], function($$) {
	var defineTests = function() {

		module("#39670 Clear Message and update focus");
		
		test('Clear message details from right pane after changing folders', function() {
			ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
			$('#content-primary .ui-listview').remove();
			ok($('#content-primary .ui-listview').is(':visible') === false, 'Detail List is not visible');
			var firstMessageInbox = $('#inbox-list li:first-child').find('.inbox-list-item');
			var firstMessageInboxSubject = firstMessageInbox.find('p:last-child').text();
			firstMessageInbox.trigger('tap');
			ok($('#content-primary .ui-listview').is(':visible'), 'Detail List is visible');
			$('#Folders-btn').trigger('tap');
			ok($('#folder-list').is(':visible'), 'Folder List is visible');

			var sentFolder = $('#folder-list li:nth-child(2)').find('.folder-list-item');
			ok(sentFolder.is(':visible'), 'Sent folder List item is visible');

			sentFolder.trigger('tap');
			ok($('#content-primary .ui-listview').is(':visible') === false, 'Detail List is not visible');

			var firstMessageSent = $('#inbox-list li:first-child').find('.inbox-list-item');
			firstMessageSent.trigger('tap');

			ok($('#content-primary .ui-listview').is(':visible'), 'Detail List is visible');

			$('#Folders-btn').trigger('tap');
			ok($('#folder-list').is(':visible'), 'Folder List is visible');
			var inboxFolder = $('#folder-list li:nth-child(1)').find('.folder-list-item');
			ok(inboxFolder.is(':visible'), 'Sent folder List item is visible');
			inboxFolder.trigger('tap');
	
			ok($('#content-primary .ui-listview').is(':visible'), 'Detail List is visible');
			var messageDetailSubject = $('#content-primary .ui-listview').find('h3').text();

			equal(firstMessageInboxSubject, messageDetailSubject, 'Subjects are the same');
			
		});

	};
	
	return {
		initialize: defineTests
	};
});
