define([
	'jQuery',
	'asyncSeries'
], function($$) {
	var defineTests = function() {

		module("#39635 Reply to Messages in SM inbox");
		
		test('Click first item in the inbox and cancel', function() {
			stop();
			async.series([function(next) {
				ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
				var firstMessageInbox = $('#inbox-list li:first-child').find('.inbox-list-item');
				firstMessageInbox.trigger('tap');
				next();
			}, function(next) {
				ok($('#content-primary .ui-listview').is(':visible'), 'Detail List is visible');
				$('#primary-reply-btn').trigger('tap');
				next();
			}, function(next) {
				var dialog = $('#compose-dialog');
				ok((dialog).is(':visible'), 'Dialog is open');
				$('#new-actions-btn').trigger('tap');
				next();
			}, function(next) {
				$('#draft-menu li:first-child a').trigger('tap');
				ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
				next();
			}], start);
		});
		
		test('Click first item in the inbox reply', function() {
			stop();
			var messageDetailBody;
			
			async.series([function(next) {
				ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
				
				var firstMessageInbox = $('#inbox-list li:first-child').find('.inbox-list-item');
				firstMessageInbox.trigger('tap');
				next();
			}, function(next) {
				ok($('#content-primary .ui-listview').is(':visible'), 'Detail List is visible');
				messageDetailBody = $('#content-primary .ui-listview').find('p').text();
				$('#primary-reply-btn').trigger('tap');
				next();
			}, function(next) {
				var dialog = $('#compose-dialog');
				ok((dialog).is(':visible'), 'Dialog is open');
				equal((dialog).find('.ui-header h1').text(), 'Reply', 'Dialog title is Reply');
				equal($('#new-message-line').siblings('span').text(), messageDetailBody, 'Dialog displays previous message content');
				ok($('#new-send-btn').hasClass('ui-disabled'), 'Send button is disabled');
				next();
			}, function(next) {
				var messageReplyBody = $('#new-body');
				messageReplyBody.val('This is a test');
				messageReplyBody.trigger('keyup');
				ok($('#new-send-btn').hasClass('ui-disabled') === false, 'Send button is enabled');
				//$('#new-send-btn').trigger('tap'); // Need to fix data layer 
				$('#new-actions-btn').trigger('tap'); //temp
				next();
			}, function(next) {
				$('#draft-menu li:first-child a').trigger('tap');//temp
				next();
			}, function(next) {
				ok($('#inbox-list').is(':visible'), 'Inbox List is visible');	//temp		
				next();
			}], start);
			
		});
	};
	
	return {
		initialize: defineTests
	};
});
