define([
	'jQuery',
	'asyncSeries'
], function($$, asyncSeries) {
	var defineTests = function() {

		module("#37897 Create, Edit, Delete, Send Messages");

		test('Single Delete and Move buttons unselectable with no message selected', function() {
			ok($('#primary-delete-btn.ui-disabled').length > 0, 'Delete button is disabled');
			ok($('#primary-move-btn.ui-disabled').length > 0, 'Move button is disabled');
		});

        test('Selecting a message activates Delete and Move buttons', function() {
			var inboxMessages = $('.inbox-list-item');
			var inboxLength = inboxMessages.length;
			ok(inboxLength > 0, 'Sufficent messages to proceed with test');
			ok($(inboxMessages[0]).trigger('tap'), "Tapping message in navigation list opens in Details pane");
        });

		test('New/Compose button opens New Message window', function() {
			ok($('#primary-new-btn').is(":visible"), 'Compose button is displayed');
			$('#primary-new-btn').trigger('tap');
			ok($('#compose-dialog').is(":visible"), 'Compose Message screen displayed');
			//tap cancel to return to Inbox view
			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Delete']" ).is(":visible"), 'Delete Draft button is displayed');
			$( "#draft-menu a[name='Delete']" ).trigger('tap');
			$('#Folders-btn').trigger('tap');
			$('.folder-list-item').eq(0).trigger('tap');
		});

		test('User can enter up to 50 characters free text in the Subject free text field', function() {
			ok($('#primary-new-btn').is(":visible"), 'Compose button is displayed');
			$('#primary-new-btn').trigger('tap');
			ok($('#compose-dialog').is(":visible"), 'Compose Message screen displayed');
			var freeTextField = $('#new-subject-line');
			var stringTooBig = "50 chars: ~!@#$%^ &*()_+&1234567890-={}|[]/:;<>?,./yyyyyyyyy";
			var stringAtMaxLength = "50 chars: ~!@#$%^ &*()_+&1234567890-={}|[]/:;<>?,.";
			freeTextField.val(stringTooBig);
			freeTextField.trigger("change");
			freeTextField.blur();

			equal(freeTextField.val(), stringAtMaxLength,'Input text truncated at 50 characters');

			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Delete']" ).is(":visible"), 'Delete Draft button is displayed');
			$( "#draft-menu a[name='Delete']" ).trigger('tap');
		});

		test('User can enter up to 5000 characters free text in the message body', function() {
			$('#primary-new-btn').trigger('tap');
			ok($('#new-body').is(':visible'), 'Message Body is visible');
			var testMessageBody = $('#new-body');
			//Define 5K character string
			var stringBodyTextRealBig = "If we handle 5000 characters in the message body, we should be okay " +
					"for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If w" +
					"e handle 5000 characters in the message body, we should be okay for the amount of expect" +
					"ed input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters" +
					" in the message body, we should be okay for the amount of expected input text from the v" +
					"eteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we" +
					" should be okay for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNO" +
					"PQRSTUVWXYZ If we handle 5000 characters in the message body, we should be okay for the " +
					"amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle" +
					" 5000 characters in the message body, we should be okay for the amount of expected input" +
					" text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the " +
					"message body, we should be okay for the amount of expected input text from the veteran. " +
					" ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we should " +
					"be okay for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVW" +
					"XYZ If we handle 5000 characters in the message body, we should be okay for the amount o" +
					"f expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 ch" +
					"aracters in the message body, we should be okay for the amount of expected input text fr" +
					"om the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message " +
					"body, we should be okay for the amount of expected input text from the veteran.  ABCDEFG" +
					"HIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we should be okay " +
					"for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If w" +
					"e handle 5000 characters in the message body, we should be okay for the amount of expect" +
					"ed input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters" +
					" in the message body, we should be okay for the amount of expected input text from the v" +
					"eteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we" +
					" should be okay for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNO" +
					"PQRSTUVWXYZ If we handle 5000 characters in the message body, we should be okay for the " +
					"amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle" +
					" 5000 characters in the message body, we should be okay for the amount of expected input" +
					" text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the " +
					"message body, we should be okay for the amount of expected input text from the veteran. " +
					" ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we should " +
					"be okay for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVW" +
					"XYZ If we handle 5000 characters in the message body, we should be okay for the amount o" +
					"f expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 ch" +
					"aracters in the message body, we should be okay for the amount of expected input text fr" +
					"om the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message " +
					"body, we should be okay for the amount of expected input text from the veteran.  ABCDEFG" +
					"HIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we should be okay " +
					"for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If w" +
					"e handle 5000 characters in the message body, we should be okay for the amount of expect" +
					"ed input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters" +
					" in the message body, we should be okay for the amount of expected input text from the v" +
					"eteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we" +
					" should be okay for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNO" +
					"PQRSTUVWXYZ If we handle 5000 characters in the message body, we should be okay for the " +
					"amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle" +
					" 5000 characters in the message body, we should be okay for the amount of expected input" +
					" text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the " +
					"message body, we should be okay for the amount of expected input text from the veteran. " +
					" ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message body, we should " +
					"be okay for the amount of expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVW" +
					"YZ If we handle 5000 characters in the message body, we should be okay for the amount of" +
					" expected input text from the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 cha" +
					"racters in the message body, we should be okay for the amount of expected input text fro" +
					"m the veteran.  ABCDEFGHIJKLMNOPQRSTUVWXYZ If we handle 5000 characters in the message b" +
					"ody, we should be okay for the amount of expected input text from the veteran. ABCDEFGHIJKL";
			testMessageBody.val(stringBodyTextRealBig);
			testMessageBody.trigger('change');
			testMessageBody.blur();
			equal($('#new-body').val(), stringBodyTextRealBig,
						'Message body accepts at least 5000 characters');
			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Delete']" ).is(":visible"), 'Delete Draft button is displayed');
			$( "#draft-menu a[name='Delete']" ).trigger('tap');
		});

		test('Message Subject field contains pick-list of message types', function() {
			$('#primary-new-btn').trigger('tap');
			var pickList = $('#new-subject-select');
			var templateNames = ["General inquiry","Medication inquiry","Appointment inquiry", "Test inquiry"];
			for (var i = 0; i < templateNames.length; i++) {
				equal(pickList.children().get(i).textContent, templateNames[i], "Option: " + pickList.children().get(i).textContent + " is present");
			}
			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Delete']" ).is(":visible"), 'Delete Draft button is displayed');
			$( "#draft-menu a[name='Delete']" ).trigger('tap');
			$('.folder-list-item').eq(0).trigger('tap');
			$('.inbox-list-item').eq(0).trigger('tap');
			ok($('#primary-delete-btn').hasClass('ui-disabled') === false, 'Delete button is enabled');
			$('#primary-delete-btn').trigger('tap');
		});

		test('Save message as Draft', function() {
			$('#primary-new-btn').trigger('tap');
			var messageSubjectFreeText = "To Save as a Draft";
			var freeTextField = $('#new-subject-line');
			freeTextField.val(messageSubjectFreeText);
			freeTextField.trigger('change');
			freeTextField.blur();
			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Drafts']" ).is(":visible"), 'Draft button is displayed');
			$( "#draft-menu a[name='Drafts']" ).trigger('mousedown').trigger('tap');
			$('#Folders-btn').trigger('tap');

			$('.folder-list-item').eq(2).trigger('tap');

			//Verify Drafts folder now contains message
			//by searching all messages for pre-defined subject free text line
			var messageFound = false;
			var draftItems = $('.inbox-list-item');
			var countDraftMessages = draftItems.length;
			for (var i = 0; i < countDraftMessages; i ++) {
				if (draftItems.eq(i).text().indexOf('To Save as a Draft') !== -1) {
					messageFound = true;
					break;
				}
			}
			equal(messageFound, true, 'Message moved to Draft folder');
			$('#Folders-btn').trigger('tap');
			$('.folder-list-item').eq(0).trigger('tap');
		});

		test('Cancel a message in progress', function() {
			$('#primary-new-btn').trigger('tap');
			var messageSubjectFreeText = "To Cancel";
			var freeTextField = $('#new-subject-line');
			freeTextField.val(messageSubjectFreeText);
			freeTextField.trigger('change');
			freeTextField.blur();
			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Delete']" ).is(":visible"), 'Draft button is displayed');
			$( "#draft-menu a[name='Delete']" ).trigger('mousedown').trigger('tap');
			//verify not saved in drafts
			$('#Folders-btn').trigger('tap');
			$('.folder-list-item').eq(2).trigger('tap');
			var notFoundDraft = false;
			var draftItems = $('.inbox-list-item');
			var countDraftMessages = draftItems.length;
			for (var i = 0; i < countDraftMessages; i ++) {
				if (draftItems.eq(i).text().indexOf('To Cancel') === -1) {
					notFoundDraft = true;
					break;
				}
			}
			equal(notFoundDraft, true, 'Message NOT moved to Draft folder');

			//verify not sent
			$('#Folders-btn').trigger('tap');
			$('.folder-list-item').eq(1).trigger('tap');
			var notFoundSent = false;
			var sentItems = $('.inbox-list-item');
			var countSentMessages = draftItems.length;
			for (var x = 0; x < countSentMessages; x ++) {
				if (sentItems.eq(i).text().indexOf('To Cancel') === -1) {
					notFoundSent = true;
					break;
				}
			}
			equal(notFoundSent, true, 'Message NOT moved to Sent folder');
			$('#Folders-btn').trigger('tap');
			$('.folder-list-item').eq(0).trigger('tap');
		});

		test('Send a message - Copied to Sent folder', function() {
			var messageSent = false;
			asyncSeries(function(){
				$('#primary-new-btn').trigger('tap');
			}, function() {
				//Send
				$('#new-send-btn').trigger('tap');
			}, function() {
				//verify sent
				$('#Folders-btn').trigger('tap');
			}, function() {
				$('.folder-list-item').eq(1).trigger('tap');
			}, function() {
				var sentItems = $('.inbox-list-item');
				var countSentMessages = sentItems.length;

				var first = function() {
					$('#Folders-btn').trigger('tap');
				}, second = function() {
					$('.folder-list-item').eq(0).trigger('tap');
				}, third = function() {
					$('.inbox-list-item').eq(0).trigger('tap');
				}, fourth = function() {
					ok($('#primary-delete-btn').hasClass('ui-disabled') === false, 'Delete button is enabled');
					$('#primary-delete-btn').trigger('tap');
				};

				for (var i = 0; i < countSentMessages; i ++) {
					if (sentItems.eq(i).text().indexOf('To Send') === -1) {
						messageSent = true;
						asyncSeries(first, second, third, fourth);
						break;
					}
				}
			}, function() {
				equal(messageSent, true, 'Sent message copied to Sent folder');
				return 2500;
			});
		});

		test('Verify Subject picklist doesnt change free text', function() {
			$('#primary-new-btn').trigger('tap');
			var freeTextField = $('#new-subject-line');
			var freeTextFieldValue = $('#new-subject-line').val();
			var messageSubjectFreeText = "To Send";
			var modifiedText = freeTextFieldValue + messageSubjectFreeText;
			var templateNames = ["General inquiry","Medication inquiry","Appointment inquiry", "Test inquiry"];
			for (var i = 0; i < templateNames.length; i++) {
				freeTextField.val(modifiedText);
				freeTextField.trigger('change').blur();
				$('#new-subject-select').val(templateNames[i]);
				$('#new-subject-select').trigger('change').blur();
				equal(freeTextField.val(), modifiedText, "Subject free text field unchanged");
			}
			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Delete']" ).is(":visible"), 'Draft button is displayed');
			$( "#draft-menu a[name='Delete']" ).trigger('mousedown').trigger('tap');
		});

		test('Required fields present to send message', function() {
			$('#primary-new-btn').trigger('tap');
			ok($('#new-send-btn').hasClass('ui-disabled') === true, 'Send button is disabled - No message body');
			var messageBody = $('#new-body');
			messageBody.val("To Send");
			messageBody.trigger('keyup');
			ok($('#new-send-btn').hasClass('ui-disabled') === false, 'Send button is enabled - message body');
			ok($('#new-actions-btn').is(":visible"), 'Actions button is displayed');
			$('#new-actions-btn').trigger('tap');
			ok($( "#draft-menu a[name='Delete']" ).is(":visible"), 'Draft button is displayed');
			$( "#draft-menu a[name='Delete']" ).trigger('mousedown').trigger('tap');
		});

	};

	return {
		initialize: defineTests
	};
});
