define([
	'jQuery',
	'asyncSeries'
], function($$, asyncSeries) {
	var defineTests = function() {

		module("#37069 Display Administrative messages to the Veteran about the SM app");

		openAboutDialog = function(folderName) {
			var aboutButton = $("#footer-about-btn");
			aboutButton.trigger('tap');
			ok($("#about").is(":visible"),
				"About dialog is shown after tapping the about button");
		};

		test('Pressing the about button opens the about dialog', function() {
			openAboutDialog();
			ok($("#about").is(":visible"),
				"About dialog is shown after tapping the about button");
			$("#cancel-about-btn").trigger('tap');
			ok($("#about").is(":visible") === false,
				"About dialog is closed after clicking the OK button");
		});

		test('Pressing the close X button closes the about dialog', function() {
			asyncSeries(openAboutDialog, function() {
				var dialogCloseX = $("#about a[title='Close']");
				ok(dialogCloseX.is(":visible"),
					"The dialog's close X button is visible");
			}, function() {
				var dialogCloseX = $("#about a[title='Close']");
				dialogCloseX.simulate('click');
			}, function() {
				ok($("#about").is(":visible") === false,
					"About dialog is closed after clicking its close X button");
			});
		});

		test('Pressing the ok button closes the about dialog', function() {
			openAboutDialog();

			var doneButton = $("#cancel-about-btn");

			ok(doneButton.is(":visible"), 
				"The dialog's OK button is visible");
			doneButton.trigger('tap');
			ok($("#about").is(":visible") === false,
				"About dialog is closed after clicking the OK button");
		});

	};
	
	return {
		initialize: defineTests
	};
});