define([
	'jQuery',
	'asyncSeries'
], function($$, asyncSeries) {
	var defineTests = function() {

		module("#37051 Actions Available for SM Inbox");

		//Call from anywhere the #Folders-btn is available
		changeToFolder = function(folderName) {
			$('#Folders-btn').trigger('tap');
			targetFolder = $('.folder-list-item h3:contains('+folderName+')');
			targetFolder.trigger('tap');

			if ($("#Folders-btn + h3:contains("+folderName+")").is(":visible")) {
				return true;
			}
		};

		/* Call from within sourceFolder
		** Only pass in sourceFolder in order to navigate back to it -
		** otherwise test will continue from destinationFolder
		*/
		moveMessage = function(uniqueId, destinationFolder, sourceFolder) {
			$("#Edit-btn").trigger('tap');
			ok($("#inbox-list").is(":visible"), "List of Editable items is displayed");
			
			var message = $('#'+uniqueId);
			message.trigger('tap');
			
			$("#action-move-btn").trigger('tap');

			var destinationFolderButton = $("#multi-move-menu a:contains("+destinationFolder+")");
			destinationFolderButton.trigger('tap');
		};

		test('Folders button is present', function() {
			var folderButton = $('#content-secondary').find(":jqmData(role='button') span").children().first().text();
			ok("Folders" == folderButton, 'Folders button present');
		});
		
		test('Verify Folder List items', function() {
			var foldersButton = $('#Folders-btn');
			foldersButton.trigger('tap');
			var listOfFolderNames = $('.folder-list-item');
			var countOfFolders = listOfFolderNames.length;
			var standardFolders = new Array("Inbox","Sent","Drafts", "Deleted", "Pharmacy", "Archive");
			var standardFolderId = 0;
			for (var i = 0; i < countOfFolders; i++) {
				var folderName = $(listOfFolderNames[i])[0].textContent.trim();
				equal(folderName, standardFolders[standardFolderId],
						"Folder name for " + folderName + " is correct");
				standardFolderId++;
			}
		});
		
		test('Count Unread Inbox Folder items', function() {
			var foldersButton = $('#Folders-btn');
			foldersButton.trigger('tap');
			var listOfFolderNames = $('.folder-list-item');
			var folderListLength = listOfFolderNames.length;
			var standardFolders = new Array("Inbox","Sent","Drafts", "Deleted", "Pharmacy", "Archive");
			$(listOfFolderNames[0]).trigger('tap');
			
			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var displayedCount = folderName.match(/\d+/); // get unread sent items
			var folderItemsList = $('.inbox-list-item');
			var itemsCount = 0;
			for (var x = 0; x < folderItemsList.length; x++) {
				if ($(folderItemsList[x]).attr('class').indexOf('read-message') === -1) {
					itemsCount++;
				}
			}
			equal(displayedCount[0], itemsCount,
				"Count for the " + folderName + " folder is correct");
			
			
		});
		
		test('Count Unread Sent Folder items', function() {
			var foldersButton = $('#Folders-btn');
			foldersButton.trigger('tap');
			var listOfFolderNames = $('.folder-list-item');
			var folderListLength = listOfFolderNames.length;
			var standardFolders = new Array("Inbox","Sent","Drafts", "Deleted", "Pharmacy", "Archive");
			$(listOfFolderNames[1]).trigger('tap');
			
			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var displayedCount = folderName.match(/\d+/); // get unread sent items
			var folderItemsList = $('.inbox-list-item');
			var itemsCount = 0;
			for (var x = 0; x < folderItemsList.length; x++) {
				if ($(folderItemsList[x]).attr('class').indexOf('read-message') === -1) {
					itemsCount++;
				}
			}
			equal(displayedCount[0], itemsCount,
				"Count for the " + folderName + " folder is correct");
			
			
		});

		test('Count Unread Drafts Folder items', function() {
			var foldersButton = $('#Folders-btn');
			foldersButton.trigger('tap');
			
			var listOfFolderNames = $('.folder-list-item');
			var folderListLength = listOfFolderNames.length;
			
			$(listOfFolderNames[2]).trigger('tap');
			
			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var displayedCount = folderName.match(/\d+/);
			var folderItemsList = $('.inbox-list-item');
			var itemsCount = 0;
			for (var x = 0; x < folderItemsList.length; x++) {
				if ($(folderItemsList[x]).attr('class').indexOf('read-message') === -1) {
					itemsCount++;
				}
			}
			equal(displayedCount[0], itemsCount,
				"Count for the " + folderName + " folder is correct");
		});
				
		test('Count Deleted Folder items', function() {
			var foldersButton = $('#Folders-btn');
			foldersButton.trigger('tap');
			
			var listOfFolderNames = $('.folder-list-item');
			var folderListLength = listOfFolderNames.length;
			
			$(listOfFolderNames[3]).trigger('tap');

			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var displayedCount = folderName.match(/\d+/);
			var folderItemsList = $('.inbox-list-item');
			var itemsCount = 0;
			for (var x = 0; x < folderItemsList.length; x++) {
				if ($(folderItemsList[x]).attr('class').indexOf('read-message') === -1) {
					itemsCount++;
				}
			}
			equal(displayedCount[0], itemsCount,
				"Count for the " + folderName + " folder is correct");
			
			
				
		});
		
		test('Count Pharmacy Folder items', function() {
			var foldersButton = $('#Folders-btn');
			foldersButton.trigger('tap');
			
			var listOfFolderNames = $('.folder-list-item');
			var folderListLength = listOfFolderNames.length;
			
			$(listOfFolderNames[4]).trigger('tap');
			
			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var displayedCount = folderName.match(/\d+/);
			var folderItemsList = $('.inbox-list-item');
			var itemsCount = 0;
			for (var x = 0; x < folderItemsList.length; x++) {
				if ($(folderItemsList[x]).attr('class').indexOf('read-message') === -1) {
					itemsCount++;
				}
			}
			equal(displayedCount[0], itemsCount,
				"Count for the " + folderName + " folder is correct");
		});
		
		test('Count Archive Folder items', function() {
			var foldersButton = $('#Folders-btn');
			foldersButton.trigger('tap');
			
			var listOfFolderNames = $('.folder-list-item');
			var folderListLength = listOfFolderNames.length;
			
			$(listOfFolderNames[5]).trigger('tap');
			
			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var displayedCount = folderName.match(/\d+/);
			var folderItemsList = $('.inbox-list-item');
			var itemsCount = 0;
			for (var x = 0; x < folderItemsList.length; x++) {
				if ($(folderItemsList[x]).attr('class').indexOf('read-message') === -1) {
					itemsCount++;
				}
			}
			equal(displayedCount[0], itemsCount,
				"Count for the " + folderName + " folder is correct");

			
		});

		
		test('Verify Edit button exposes message selector', function() {

			ok($("#Edit-btn").is(":visible"), "Edit button is displayed");

			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			folderName = folderName.substring(0,5);
			equal(folderName, "Inbox", "Inbox is open");
			$("#Edit-btn").trigger('tap');

			ok($("#inbox-list").is(":visible"), "List of Editable items is displayed");
			var checkboxSelector = $('.edit-list-item').get(0);
			$(checkboxSelector).trigger('tap');

			
			ok($('.edit-list-item').get(0).children[3].className.indexOf('ui-icon-checkbox-on') !== -1, "Checkbox is selected");
			$(checkboxSelector).trigger('tap');

			ok($('.edit-list-item').get(0).children[3].className.indexOf('ui-icon-checkbox-on') === -1, "Checkbox is unselected");
			
			$("#Cancel-btn").trigger('tap');
			
			var foldersButton = $('#Folders-btn');
			
		});

		test('Verify Move action from Inbox to Pharmacy folder', function() {
			
			$('#Folders-btn').trigger('tap');
			pharmacyFolderButton = $('.folder-list-item h3:contains("Pharmacy")');
			pharmacyFolderButton.trigger('tap');

			var folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			folderName = folderName.substring(0,8);
			equal(folderName, "Pharmacy", "Pharmacy is open");
			
			$('#Folders-btn').trigger('tap');
			inboxFolderButton = $('.folder-list-item h3:contains("Inbox")');
			inboxFolderButton.trigger('tap');

			folderName = $('#content-secondary').find(":jqmData(role='header') h3").text();
			folderName = folderName.substring(0,5);
			equal(folderName, "Inbox", "Inbox is open");
			
			var firstInboxItemUniqueId = $("#inbox-list li a").eq(0).attr("id");
			ok($('#' + firstInboxItemUniqueId).is(":visible"),
				"First item is visible in Inbox folder list");

			moveMessage(firstInboxItemUniqueId, "Pharmacy");

			ok($('#' + firstInboxItemUniqueId).length === 0,
				"Message moved, no longer in list");
				
			changeToFolder("Pharmacy");

			ok($('#' + firstInboxItemUniqueId).is(":visible"),
				"Moved message is visible in Pharmacy folder list");

			moveMessage(firstInboxItemUniqueId, "Inbox");
		});

		test('Tapping Edit button shows Edit actions', function() {

			ok($("#Edit-btn").is(":visible"),
				"Given the Edit button is visible");

			ok($("#Edit-btn").mousedown().click(),
				"When I click the Edit button");

			ok($("#action-list").is(":visible"),
				"Then the Action list is visible");
			ok($("#action-delete-btn").is(":visible"),
				"Then I can see the Delete button on the Action list");
			ok($("#action-move-btn").is(":visible"),
				"Then I can see the Move button on the Action list");
		});

		test('Tapping Edit button changes to Cancel', function() {

			ok($("#Edit-btn").is(":visible"),
				"Given the Edit button is visible");

			ok($("#Edit-btn").mousedown().click(),
				"When I click the Edit button");

			ok($("#Cancel-btn").is(":visible"),
				"Then the Cancel button is visible");
		});

		test('Tapping Delete button deletes selected items', function() {

			ok($("#Edit-btn").is(":visible"),
				"Given the Edit button is visible");

			ok($("#Edit-btn").mousedown().click(),
				"When I click the Edit button");

			ok($("#action-list").is(":visible"),
				"Then the Action list is visible");

			ok($("#action-delete-btn").is(":visible"),
				"Then I can see the Delete button on the Action list");

			var firstInboxItem = $("#inbox-list li a").eq(0);
			var firstInboxItemUniqueId = firstInboxItem.attr("id");
			
			ok(firstInboxItem.tap(),
				"When I tap the first list item");

			var firstInboxItemIsChecked = $("#inbox-list li").eq(0).find('.ui-icon-checkbox-on').length;

			ok(firstInboxItemIsChecked,
				"Then I can see it is checked");

			ok($("#action-delete-btn").tap(),
				"When I tap the Delete button");

			ok($("#" + firstInboxItemUniqueId).length < 1,
				"Then that first item is gone");


			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Deleted')").trigger('tap'),
				"When I click on the Deleted folder");
			
			ok($("#" + firstInboxItemUniqueId).length > 0,
				"Then I can see the message I just deleted");

			//moveMessage(firstInboxItemUniqueId, "Inbox");
		});
		
		test("Edit button not available in Sent", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Sent')").trigger('tap'),
				"When I click on the Sent folder");

			ok($("#Edit-btn").length === 0,
				"Then the Edit button is not there");

		});

		test("Move button not available in Drafts", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Drafts')").trigger('tap'),
				"And I click on the Drafts folder");

			ok($("#Edit-btn").trigger("tap"),
				"And I tap on the Edit button");

			ok($("#action-delete-btn").is(":visible"),
				"Then the Delete button is visible");

			ok($("#action-move-btn").length === 0,
				"But the Move button is not there");

		});
		
		test('Single Delete a message', function() {
			var inboxMessages = $('.inbox-list-item');
			var inboxLength = inboxMessages.length;
			var firstInboxItem = $("#inbox-list li a").eq(0);
			var messageToDeleteID = firstInboxItem.attr("id");
			asyncSeries(function() {
				ok(inboxLength > 0, 'Sufficent messages to proceed with test');
				// Select the first item
				$(firstInboxItem).trigger('tap');
			}, function() {
				//Delete button active
				ok($('#primary-delete-btn').hasClass('ui-disabled') === false, 'Delete button is enabled');
				//Tap Delete button
				$('#primary-delete-btn').trigger('tap');
			}, function() {
				//TP Folders button
				$('#Folders-btn').trigger('tap');
			}, function() {
				listOfFolderNames = $('.folder-list-item');
				//Select Deleted folder
				$(listOfFolderNames[3]).trigger('tap');
			}, function() {
				//Look for deleted message
				var deletedMessages = $('.inbox-list-item');
				var messageFound = false;
				for (var i = 0; i < deletedMessages.length; i++) {
					deletedMessage = $("#inbox-list li a").eq(i);
					idOfDeletedMessage = deletedMessage.attr("id");
					if (idOfDeletedMessage == messageToDeleteID) {
						messageFound = true;
					}
				}
				equal(messageFound, true, 'Message deleted, moved to Deleted folder');
				
				moveMessage(messageToDeleteID, "Inbox");
			});
		});

		test("Move button in Deleted folder does not show Sent or Drafts", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Deleted')").trigger('tap'),
				"When I click on the Deleted folder");

			ok($("#Edit-btn").trigger('tap'),
				"When I tap on the Edit button");

			
			var firstInboxItem = $("#inbox-list li a").eq(0);

			ok(firstInboxItem.trigger('tap'),
				"When I tap on the first list item");

			var firstInboxItemIsChecked = $("#inbox-list li").eq(0).find('.ui-icon-checkbox-on').length;

			ok(firstInboxItemIsChecked,
				"Then I can see it is checked");


			ok($("#action-move-btn").trigger('tap'),
				"When I tap on the Move button");

			ok($("#multi-move-menu").is(":visible"),
				"Then I can see the Move menu");

			ok($("#multi-move-menu a:contains('Inbox')").is(":visible"),
				"Then I can see the Move to Inbox command");

			ok($("#multi-move-menu a:contains('Sent')").length === 0,
				"Then I can NOT see the Move to Sent command");

			ok($("#multi-move-menu a:contains('Drafts')").length === 0,
				"Then I can NOT see the Move to Drafts command");

			$('#multi-move-menu').popup('close');
		});

		test("Move button in Inbox folder does not show Sent, Deleted, or Drafts", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Inbox')").trigger('tap'),
				"When I click on the Inbox folder");

			ok($("#Edit-btn").trigger('tap'),
				"When I tap on the Edit button");

			
			var firstInboxItem = $("#inbox-list li a").eq(0);

			ok(firstInboxItem.trigger('tap'),
				"When I tap on the first list item");

			var firstInboxItemIsChecked = $("#inbox-list li").eq(0).find('.ui-icon-checkbox-on').length;

			ok(firstInboxItemIsChecked,
				"Then I can see it is checked");

			ok($("#action-move-btn").trigger('tap'),
				"When I tap on the Move button");

			ok($("#multi-move-menu").is(":visible"),
				"Then I can see the Move menu");

			ok($("#multi-move-menu a:contains('Sent')").length === 0,
				"Then I can NOT see the Move to Sent command");

			ok($("#multi-move-menu a:contains('Deleted')").length === 0,
				"Then I can NOT see the Move to Deleted command");

			ok($("#multi-move-menu a:contains('Drafts')").length === 0,
				"Then I can NOT see the Move to Drafts command");

			$('#multi-move-menu').popup('close');
		});

		test("Move button in Custom folders do not show Sent, Deleted, or Drafts", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			var customFoldersLength = $("#content-secondary ul h3:not('[name='Inbox'], [name='Sent'], [name='Drafts'], [name='Deleted']')").length;

			for (var i = 0; i < customFoldersLength; i++) {

				var customFolders = $("#content-secondary ul h3:not('[name='Inbox'], [name='Sent'], [name='Drafts'], [name='Deleted']')"),
					currentFolderName = customFolders.eq(i).text();

				ok(customFolders.eq(i).trigger('tap'),
					"When I click on the " + customFolders.eq(i).attr('name') + " folder");

				ok($("#Edit-btn").trigger('tap'),
					"When I tap on the Edit button");


				//Verify Custom folder items greater than zero
				var customFolderitems = $('.edit-list-item'),
					customFolderLength = customFolderitems.length,
					customFolderIsEmpty = (customFolderLength === 0);

				//Variables to connect setup and teardown
				var ConditionalFirstItem,
					ConditionalFirstItemUniqueId;

				//If not, need to add sufficient # of items to folder, then proceed
				if (customFolderIsEmpty) {

					ok(true,
						"***** " + currentFolderName + " folder was empty; entering <move item from Inbox to Custom folder>");

					ok($('#Folders-btn').trigger('tap'),
						"When I click on the Folders button");

					ok($("h3:contains('Inbox')").trigger('tap'),
						"When I click on the Inbox folder");

					ok($("#Edit-btn").trigger('tap'),
						"When I tap on the Edit button");

					
					ConditionalFirstItem = $("#inbox-list li a").eq(0);
					ConditionalFirstItemUniqueId = ConditionalFirstItem.attr('id');


					ok(ConditionalFirstItem.trigger('tap'),
						"When I tap on the first list item");

					var ConditionalFirstItemIsChecked = $("#inbox-list li").eq(0).find('.ui-icon-checkbox-on').length;

					ok(ConditionalFirstItemIsChecked,
						"Then I can see it is checked");


					ok($("#action-move-btn").trigger('tap'),
						"When I tap on the Move button");

					ok($("#multi-move-menu").is(":visible"),
						"Then I can see the Move menu");

					equal($("#multi-move-menu a:contains(" + currentFolderName + ")").text(), currentFolderName,
						"Then I can see the Move to " + currentFolderName + " command");

					ok($("#multi-move-menu a:contains("+currentFolderName+")").trigger('tap'),
						"When I clicked on the current folder name");

					$('#multi-move-menu').popup('close');

					ok($('#Folders-btn').trigger('tap'),
						"When I click on the Folders button");

					ok($("h3[name='Folders']").is(":visible"),
						"Then I am in the Folders section");

					
					customFolders = $("#content-secondary ul h3:not('[name='Inbox'], [name='Sent'], [name='Drafts'], [name='Deleted']')");

					ok(customFolders.eq(i).trigger('tap'),
						"When I click on the " + customFolders.eq(i).attr('name') + " folder");

					ok($("h3[name="+currentFolderName+"]").is(":visible"),
						"Then I am in the " + currentFolderName + " section");

					ok($("#Edit-btn").trigger('tap'),
						"When I tap on the Edit button");

					ok(true, "***** leaving <move item from Inbox to Custom folder>");

				}
								
				
				var firstItem = $("#inbox-list li a").eq(0);

				ok(firstItem.trigger('tap'),
					"When I tap on the first list item");

				var firstItemIsChecked = $("#inbox-list li").eq(0).find('.ui-icon-checkbox-on').length;

				ok(firstItemIsChecked,
					"Then I can see it is checked");


				ok($("#action-move-btn").trigger('tap'),
					"When I tap on the Move button");

				ok($("#multi-move-menu").is(":visible"),
					"Then I can see the Move menu");

				ok($("#multi-move-menu a:contains('Sent')").length === 0,
					"Then I can NOT see the Move to Sent command");

				ok($("#multi-move-menu a:contains('Deleted')").length === 0,
					"Then I can NOT see the Move to Deleted command");

				ok($("#multi-move-menu a:contains('Drafts')").length === 0,
					"Then I can NOT see the Move to Drafts command");

				$('#multi-move-menu').popup('close');

				ok($("#Folders-btn").trigger('tap'),
					"When I tap on the Folders button");

			}

		});

		test("In Inbox, Single Move button has no Deleted, Sent, or Drafts options", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Inbox')").trigger('tap'),
				"When I click on the Inbox folder");

			
			var firstItem = $("#inbox-list li a").eq(0),
				firstItemUniqueId = firstItem.attr('id');

			ok(firstItem.trigger('tap'),
				"When I tap on the first list item as my Message of Focus");

			var firstItemMoveButtonIsEnabled = ($("#primary-move-btn.ui-disabled").length === 0);
			
			ok(firstItemMoveButtonIsEnabled,
				"Then I can see the Move button is enabled");


			ok($("#primary-move-btn").trigger('tap'),
				"When I tap on the Move button");

			ok($("#move-menu").is(":visible"),
				"Then I can see the Move menu");

			ok($("#move-menu a:contains('Deleted')").length === 0,
				"Then I can NOT see the Move to Deleted command");

			ok($("#move-menu a:contains('Sent')").length === 0,
				"Then I can NOT see the Move to Sent command");

			ok($("#move-menu a:contains('Drafts')").length === 0,
				"Then I can NOT see the Move to Drafts command");

			$("#move-menu").popup('close');

		});
	
		test("In Inbox, Single Move button functions properly", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Inbox')").trigger('tap'),
				"When I click on the Inbox folder");

			
			var firstItem = $("#inbox-list li a").eq(0),
				firstItemUniqueId = firstItem.attr('id');

			ok(firstItem.trigger('tap'),
				"When I tap on the first list item as my Message of Focus");

			var firstItemMoveButtonIsEnabled = ($("#primary-move-btn.ui-disabled").length === 0);
			
			ok(firstItemMoveButtonIsEnabled,
				"Then I can see the Move button is enabled");


			ok($("#primary-move-btn").trigger('tap'),
				"When I tap on the Move button");

			ok($("#move-menu").is(":visible"),
				"Then I can see the Move menu");

			var foldersAvailableToMoveTo = $("#move-menu a:not(\":contains('Inbox'), :contains('Sent'), :contains('Drafts'), :contains('Deleted')\")").length;

			/*
			function verifyMessageOfFocus() {
				ok($("#"+firstItemUniqueId).length === 0,
					"Then I can NOT see my Message of Focus anymore");
			}
			*/
			
			var first = function() {
				ok($("#"+firstItemUniqueId).length === 0,
					"Then I can NOT see my Message of Focus anymore");
				ok($("#Folders-btn").trigger('tap'),
					"When I tap the Folders button");
			}, second = function() {
				ok($("h3:contains('" + currentCustomFolderName + "')").trigger('tap'),
					"When I click on the " + currentCustomFolderName + " folder");
			}, third = function() {
				ok($("#"+firstItemUniqueId).is(":visible"),
					"Then I can see my Message of Focus now");
				// Move message back for cleanup
				ok($("#"+firstItemUniqueId).trigger('tap'),
					"When I tap my Message of Focus");
			}, fourth = function() {
				firstItemMoveButtonIsEnabled = ($("#primary-move-btn.ui-disabled").length === 0);
				ok(firstItemMoveButtonIsEnabled,
					"Then I can see the Move button is enabled");
				ok($("#primary-move-btn").trigger('tap'),
					"When I tap on the Move button");
			}, fifth = function() {
				ok($("#move-menu").is(":visible"),
					"Then I can see the Move menu");
				ok($("#move-menu a:contains('Inbox')").trigger('tap'),
					"When I tap on the Move to Inbox command");
			}, sixth = function() {
				ok($("#"+firstItemUniqueId).length === 0,
					"Then I can NOT see my Message of Focus anymore");
				ok($('#Folders-btn').trigger('tap'),
					"When I click on the Folders button");
			}, seventh = function() {
				ok($("h3:contains('Inbox')").trigger('tap'),
					"When I click on the Inbox folder");
			}, eight = function() {
				ok($("#"+firstItemUniqueId).is(":visible"),
					"Then I can see my Message of Focus now");
				ok($("#primary-move-btn").trigger('tap'),
					"When I tap on the Move button");
			};
			
			if (foldersAvailableToMoveTo > 0) {
				
				for (var i = foldersAvailableToMoveTo - 1; i >= 0; i--) {

					var customFolderList = $("#move-menu a:not(\":contains('Inbox'), :contains('Sent'), :contains('Drafts'), :contains('Deleted')\")"),
						currentCustomFolder = customFolderList.eq(i),
						currentCustomFolderName = currentCustomFolder.text();

					ok(currentCustomFolder.trigger('tap'),
						"When I tap the Move to " + currentCustomFolderName + " folder command");

					asyncSeries(first, second, third, fourth, fifth, sixth, seventh, eigth);
				}

			} else {

				ok(false, "!!!!! Inbox folder items have no valid 'Move to Folder' options available");
			}

			$("#move-menu").popup('close');

		});

		test("In Sent, Single Move is disabled", function() {

			ok(changeToFolder('Sent'),
				"When I move to the Sent Folder");

			var firstItem = $("#inbox-list li a").eq(0);

			ok(firstItem.trigger('tap'),
				"And I tap the first message");

			ok($("#primary-move-btn.ui-disabled").length,
				"Then I can see the move button is disabled");

		});

		test("In Drafts, Single Move is disabled", function() {

			ok(changeToFolder('Drafts'),
				"When I move to the Drafts Folder");

			var firstItem = $("#inbox-list li a").eq(0);

			ok(firstItem.trigger('tap'),
				"And I tap the first message");

			ok($("#primary-move-btn.ui-disabled").length,
				"Then I can see the move button is disabled");

		});

		test("In Deleted, Single Move has no Deleted, Sent, or Drafts options", function() {

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			ok($("h3:contains('Deleted')").trigger('tap'),
				"When I click on the Deleted folder");

			
			var firstItem = $("#inbox-list li a").eq(0),
				firstItemUniqueId = firstItem.attr('id');

			ok(firstItem.trigger('tap'),
				"When I tap on the first list item as my Message of Focus");

			var firstItemMoveButtonIsEnabled = ($("#primary-move-btn.ui-disabled").length === 0);
			
			ok(firstItemMoveButtonIsEnabled,
				"Then I can see the Move button is enabled");


			ok($("#primary-move-btn").trigger('tap'),
				"When I tap on the Move button");

			ok($("#move-menu").is(":visible"),
				"Then I can see the Move menu");

			ok($("#move-menu a:contains('Deleted')").length === 0,
				"Then I can NOT see the Move to Deleted command");

			ok($("#move-menu a:contains('Sent')").length === 0,
				"Then I can NOT see the Move to Sent command");

			ok($("#move-menu a:contains('Drafts')").length === 0,
				"Then I can NOT see the Move to Drafts command");

			$('#move-menu').popup('close');
		});

		test("In Custom folders, Single Move has no Deleted, Sent, or Drafts options", function() {

			// put message in pharmacy
			$('#inbox-list a:first').trigger('tap');
			$('#primary-move-btn').trigger('tap');
			$('#move-menu a:contains("Pharmacy")').trigger('tap');
			// $('#move-menu-popup').popup('close');

			// main section

			ok($('#Folders-btn').trigger('tap'),
				"When I click on the Folders button");

			var customFolderList = $("#content-secondary ul h3:not('[name='Inbox'], [name='Sent'], [name='Drafts'], [name='Deleted']')"),
				customFolderListLength = customFolderList.length;

			for (var i = 0; i < customFolderListLength; i++) {

				currentFolderName = $("#content-secondary ul h3:not('[name='Inbox'], [name='Sent'], [name='Drafts'], [name='Deleted']')").eq(i);

				ok($(currentFolderName).trigger('tap'),
					"When I click on the "+ currentFolderName.text() +" folder");

				
				var firstItem = $("#inbox-list li a").eq(0),
					firstItemUniqueId = firstItem.attr('id');

				ok(firstItem.trigger('tap'),
					"When I tap on the first list item as my Message of Focus");

				var firstItemMoveButtonIsEnabled = ($("#primary-move-btn.ui-disabled").length === 0);
				
				ok(firstItemMoveButtonIsEnabled,
					"Then I can see the Move button is enabled");


				ok($("#primary-move-btn").trigger('tap'),
					"When I tap on the Move button");

				ok($("#move-menu").is(":visible"),
					"Then I can see the Move menu");

				ok($("#move-menu a:contains('Deleted')").length === 0,
					"Then I can NOT see the Move to Deleted command");

				ok($("#move-menu a:contains('Sent')").length === 0,
					"Then I can NOT see the Move to Sent command");

				ok($("#move-menu a:contains('Drafts')").length === 0,
					"Then I can NOT see the Move to Drafts command");

				$('#move-menu').popup('close');

				ok($('#Folders-btn').trigger('tap'),
					"When I click on the Folders button");

			}

		});


	};
	
	return {
		initialize: defineTests
	};
});