define([
	'jQuery'
], function($$) {
	var defineTests = function() {

		module("#36817 Receive and View Secure Message");
		
		test('App Title Displayed', function() {
			var appTitleBar = $('#content-primary').find(":jqmData(role='header') h3").text();
			ok("Secure Messaging" == appTitleBar, 'App title is displayed');
		});
		
		test('Logged in Username is displayed', function() {
			ok($('#footer-username li').text().indexOf("patient66, zztest") !== -1, 'patient66, zztest is in user bar');
		});
		
		test('Inbox Title Displayed', function () {
			var inboxTitleBar = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var inboxListItemList = $('.inbox-list-item');
			var inboxListLength = inboxListItemList.length;
			
			ok("Inbox" == inboxTitleBar.substring(0,5), 'Inbox title is displayed');
		});
		
		test('Test number of unread messages', function() {
			ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
			
			var inboxListItemList = $('.inbox-list-item');
			var inboxListLength = inboxListItemList.length;
			notEqual(inboxListLength, 0, 'Inbox List is not empty');
			
			var inboxHeader = $('#content-secondary').find(":jqmData(role='header') h3").text();
			var numberOfUnreadMessages = inboxHeader.match(/\d+/);
			
			var count = 0;
			for (var i = 0; i < inboxListLength; i ++) {
				if ($(inboxListItemList[i]).attr('class').indexOf('read-message') === -1) {
					count++;
				}
			}
			
			ok(numberOfUnreadMessages[0] == count, 'Number of unread messages is correctly displayed');
		});
		
		test('Verify Message Metadata Elements', function() {
			ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
			var inboxListLength = $('#inbox-list li').size();
			var countOfMessagesToTest = 3;
			ok(inboxListLength >= countOfMessagesToTest, 'Sufficient messages to test exist');
			
			for (var i = 1; i < countOfMessagesToTest; i ++) {
				var sentDate = $('#inbox-list li:nth-child(' + i + ')').find('strong').text();
				var month = sentDate.substring(0, 2);
				ok(month.length == 2, 'Month length correct');
				var day = sentDate.substring(3,5);
				ok(day.length == 2, 'Days length correct');
				var year = sentDate.substring(6);
				ok(year.length == 4, 'Year length correct');
				var messageSender = $('#inbox-list li:nth-child(' + i + ') h3').text();
				ok("Chaplain Service - Test VAMC" == messageSender, 'From: line is correct');
				ok($('#inbox-list li:nth-child(1) p').text().search('Inbox Subject') > 0, 'Verify the subject is populated');
				
			}
		});
		
		test('Verify Message Details', function() {
			ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
			
			var inboxListItemList = $('.inbox-list-item');
			var inboxListLength = inboxListItemList.length;
			var beforeRead = 0;
			var afterRead = 0;
			var notRead = false;
			var countOfMessagesToTest = 2;
			ok(inboxListLength >= countOfMessagesToTest, 'Sufficient messages to test exist');
			
			for (var i = 0; i < countOfMessagesToTest; i ++) {
				if ($(inboxListItemList[i]).attr('class').indexOf('read-message') === -1) {
					beforeRead++;
					notRead = true;
				}
				ok($(inboxListItemList[i]).trigger('tap'), "Tapping message in navigation list opens in Details pane");
				if (notRead) {
					notRead = false;
				}
				if ($(inboxListItemList[i]).attr('class').indexOf('read-message') === -1) {
					afterRead++;
				}
				if (notRead) {
					ok(afterRead == beforeRead - 1, "Status correctly updates upon opening");
				}
				var messageDetails = $('#content-primary').find(":jqmData(role='listview') li");
				var messageNumber = inboxListItemList[i].id;
				var idNumber = messageNumber.substr(3);
				ok("From Chaplain Service - Test VAMC" == messageDetails[0].textContent.trim(), 'From: line is correct');
				ok("To Gallow Younger" == messageDetails[1].textContent.trim(), 'TO: line is correct');
				ok("Inbox Subject " + idNumber + " extra text 30 characters" == messageDetails[2].textContent.trim(), 'Subject Line is correct');
				
				var dateTimeStamp = messageDetails.eq(3).text().split(' ');
				var colonPosition = dateTimeStamp[4].split(':');
				var	hours = colonPosition[0];
				var	minutes = colonPosition[1];
				var	dayNightIndicator = dateTimeStamp[5].trim();
				
				equal(colonPosition.length, 2, 'Colon follows Hours digits');
				equal(hours.length, 2, "Hours format is correct");
				equal(minutes.length, 2, "Minutes format is correct");
				equal(dayNightIndicator.length, 2, 'AM/PM indicator is correct');
				
				ok("Inbox Message " + idNumber == messageDetails[4].textContent.trim(), "Message body correct");
				ok(messageDetails.length === 5, 'Message details contains five details');
				
				var messageContent = $(messageDetails[4]).text();
				ok(typeof messageContent !== 'undefined' && messageContent && messageContent.trim(), "Message content is not empty");
				beforeRead = 0;
				afterRead = 0;
				notRead = false;
			}
		});
		
		test('Test reverse chronological order', function() {
			ok($('#inbox-list').is(':visible'), 'Inbox List is visible');
			
			var inboxListItemList = $('.inbox-list-item');
			var inboxListLength = inboxListItemList.length;
			ok(inboxListLength > 0, 'Inbox List is not empty');
			
			var previousDate = new Date();
			for (var i = 0; i < inboxListLength; i ++) {
				var dateString = $(inboxListItemList[i]).children().first().find('strong').text(),
					date = new Date(dateString);
				
				ok(previousDate >= date, 'Previous date is greater than or equal to current date (reverse chronological order)');
				previousDate = date;
			}
		});
	};
	
	return {
		initialize: defineTests
	};
});
