define([
	'jQuery'
], function($$) {
	var defineTests = function() {

		module("#39624 Handle case of user that opts out of secure messaging");

		test('Verify the message text when person has no Secure Messaging account', function() {
			var messageHeader = $('#test h3').text();
			equal(messageHeader, "No Secure Messaging Account", 'Verify the prompt for the No Matching Account');
			equal($('#test ul li').first().text(), 
					"In order to use this app, there are two account requirements.", 
					'Verify the first bullet item');
			equal($('#test ul ol li:nth-child(1)').text(), 
					'My HealtheVet Account', 
					'Verify the first account requirement');
			equal($('#test ul ol li:nth-child(2)').text(), 
					'Secure Messaging Account', 
					'Verify the second account requirement');
			equal($('#test ul li:nth-child(3)').text(), 
					'If you need a My HealtheVet account, please visit https://www.myhealth.domain/index.html', 
					'Verify the My Healthy Vet account link text');
			equal($('#test ul li:nth-child(4)').text(), 
					'Once you have a My HealtheVet account, you\'ll need to create a Secure Messaging account here', 
					'Verify the Secure Messaging account text');
		});

//		test('Verify that clicking OK returns the person to the launchpad', function() {
//			$('#close-dialog-btn').trigger('tap');
//			equal($('#header').text().trim(), "Launchpad", 'Verify that clicking the Return to Launchpad button takes you to the launchpad')
//			//Wait for launchpad to load
//			stop();
//			setTimeout(function() {
//				start();
//			}, 5000);
//		});

	};
	
	return {
		initialize: defineTests
	};
});
