define([
	'jQuery',
	'async'

], function(jQuery, async){

	var $$ = jQuery.noConflict(true),
		myFrame = $$("#myFrame");

	var setup = function(){
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;

		require(['common']);
		require(['1577']);
		require(['1781']);
		require(['527']);
		require(['528']);
		require(['39281']);
		require(['detailsDisplay']);

		async.series([
			function(next){
				$$(document).ready(function(){
					next();
				});
			},
			function(next){
				myFrame.attr('src', referencePath + '../../logout')
					.one('load', function(){
						next();
					});
			},
			function(next){
				myFrame.attr('src', referencePath + '../../oauthlogin?redirect_uri=' + referencePath + '../../scheduling2')
					.one('load', function(){
						next();
					});
			},
			function(next){
				//grab jQuery from inside the document
				$ = jQuery = myFrame[0].contentWindow.jQuery;

				$("#name-c").val('zztest.staff01');
				$("#password").val('pass');
				$('#autocomplete-container input').val('DC VAMC');
				$('#facilityName').val('DC VAMC');
				$('#facilityCode').val('688');

				$("#logonForm").submit();
				myFrame.one('load', function(){
					$ = jQuery = myFrame[0].contentWindow.jQuery;
					next();
				});
			}
		], function(){
			start();
		});

		QUnit.testStart(function(){
			stop();
			myFrame.attr('src', referencePath + '../../scheduling2')
				.on("load", function(){
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					//turn off async so tests will wait for ajax results
					$.ajaxSetup({ async: false });

					$.getScript(referencePath + "../jquery.simulate.js");

					//turn off animations so they do not break tests
					$.support.cssTransitions = false;
					$.fx.off = true;

					QUnit.start();

				});
		});

	};

	function defineTests(){
		commonTests.initialize();
		scheduling2.initialize();
	}

	return {
		initialize: setup
	};
});
