define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		
//***** TESTS *****//
	
	module("#527/622 - User can see that a message has been added/changed for an Appointment Request");
	
	test("#1547 - Validate that a new message exists for an Appointment Request", function() {
		asyncSeries(function(){
			if ($('#appointmentRequestTable').is(':visible')) {
				ok($("#appointmentRequestTable").is(":visible"),
				"Appointment Requests table is displayed");
				}
			
				return 1000;
				
			}, function() {
				ok($('.ui-title').is(':visible'),
				"Title is visible");

			//Then I can see the header info
				ok($('.ui-title:contains("Veteran Appointments")').text(),
					"Then I can see Veteran Appointments on the title bar");
			
			}, function() {
				var titleMsg = "New Unread Message(s)";
			//Validate the new message icon display 
				$('#appointmentRequestTable i:nth-child(1).fonticon.chat.new-message').is(':visible');
				equal($('#appointmentRequestTable i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
						"New message icon exists");
			//Validate Title for new message icon
				ok($('.new-message').prop('title'), titleMsg,
					'Then the New Message Indicator has a title attribute and it reads: "'+titleMsg+'"');					

			//Validate the new column 'Alerts' where new message icon is displayed.
				equal($("#appointmentRequestTable th:nth-child(1)").text(),'Alerts','Alerts Column Label');
			
		});
	});
});
