define([
	'jQuery',
	'async',
	'common',
	'39281'

], function(jQuery, async, commonTests, scheduling){

	var $$ = jQuery.noConflict(true),
		myFrame = $$("#myFrame");

	var setup = function(){
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
		defineTests();

		async.series([
			function(next){
				$$(document).ready(function(){
					next();
				});
			},
			function(next){
				myFrame.attr('src', referencePath + '../../logout')
					.one('load', function(){
						next();
					});
			},
			function(next){
				myFrame.attr('src', referencePath + '../../oauthlogin?redirect_uri=' + referencePath + '../../scheduling-calendar-view')
					.one('load', function(){
						next();
					});
			},
			function(next){
				//grab jQuery from inside the document
				$ = jQuery = myFrame[0].contentWindow.jQuery;

				$("#name-c").val('zztest.staff01');
				$("#password").val('pass');
				$('#autocomplete-container input').val('DC VAMC');
				$('#facilityName').val('DC VAMC');
				$('#facilityCode').val('688');

				$("#logonForm").submit();
				myFrame.one('load', function(){
					$ = jQuery = myFrame[0].contentWindow.jQuery;
					next();
				});
			},
			function(next){
				setTimeout(function(){
					if($('h4:contains("DISCLAIMER")').length === 1){
						$('#accept-btn').trigger('tap');
					}
					next();

				}, 500);
			}
		], function(){
			start();
		});

		QUnit.testStart(function(){
			stop();
			myFrame.attr('src', referencePath + '../../scheduling')
				.on("load", function(){
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					//turn off async so tests will wait for ajax results
					$.ajaxSetup({ async: false });

					$.getScript(referencePath + "../jquery.simulate.js");

					//turn off animations so they do not break tests
					$.support.cssTransitions = false;
					$.fx.off = true;

					QUnit.start();
				});
		});

	};

	function defineTests(){
		commonTests.initialize();
		scheduling.initialize();

	}

	return {
		initialize: setup
	};
});
