define([
	'jQuery',
	'asyncSeries',
	'testUtilities'
], function($$, asyncSeries, testUtilities) {
	var defineTests = function() {

		module("#1134/#1854 - Patient Search");

		function getResultsCount()
		{
			return $('#patient-search-results li a').length;	
		}
		
		function getName()
		{
			return $('#patient-search-results li:nth-child(2) a h3').eq(0).text();
		}

		
		test('#2073 - a.Verify that search results are paged at 20 records', function() {

			searchPatient('patient26');
			
			var resultLength = getResultsCount();
			equal(resultLength, 20, 'Verify that only 20 rows are displayed');
			equal($('#displayed-result-count').text(), 'Displaying 20 results',
					'Verify the correct count of records is displayed');

		});

		test('#2073 - b.Verify searching by last name', function() {
			searchPatient('patient66');
			
			var patientName = getName();
			equal(patientName, 'patient66, zztest', 'Verify the name of the returned results');
		});
		
		test('#2073 - c.Verify searching by SSN', function() {
			searchPatient('999999926');
			
			var resultLength = getResultsCount();
			equal(resultLength, 1, 'Verify that only 1 person is displayed');

			var patientName = getName();
			equal(patientName, 'patient26, zztest', 'Verify the name of the returned results');
		});
		
		test('#2073 - d.Verify searching by last name,first name', function() {
			searchPatient('patient66, zztest');
			
			var patientName = getName();
			equal(patientName, 'patient66, zztest', 'Verify the name of the returned results');
		});
		
		test('#2073 - e.Verify searching by 1st initial of last name + last 4 of SSN', function() {
			searchPatient('p9956');
			
			var resultLength = getResultsCount();
			equal(resultLength, 1, 'Verify that only one result is returned');
			
			var patientName = getName();
			equal(patientName, 'patient56, zztest', 'Verify the name of the returned results');
		});

		test('#2073 - f.Verify that searching by special characters do not generate errors', function() {
			searchPatient("\u070f\u17b4\u17b5!@#$%^&*()_+=-~`");
			
			var resultLength = getResultsCount();
			equal(resultLength, 0, 'Verify that no rows are displayed');
			
			equal($('#patient-search-results li:nth-child(1) span').eq(0).text(),
					'Displaying 0 results', 
					'Verify the text when no results are returned');
			
		});
		
		test('#2073 - g.Verify that the system allows searching names with apostrophes', function() {
			searchPatient("patient'69");
			
			var patientName = getName();
			equal(patientName, "patient'69, zztest", 'Verify the name of the returned results');			
		});
		
		test('#2073 - h.Verify that the system allows searching names with hyphens', function() {
			searchPatient("patient-71");
			
			var patientName = getName();
			equal(patientName, "patient-71, zztest", 'Verify the name of the returned results');			
		});

		test('#2073 - i.Verify that the system allows searching names with spaces', function() {
			searchPatient("patient 70");
			
			var patientName = getName();
			equal(patientName, "patient 70, zztest", 'Verify the name of the returned results');			
		});

		test('#2074 - Patient details appear in title bar and footer', function() {
			searchPatient('patient66');
			asyncSeries(function() {
			
			}, function() {
				
				$('#patient-search-results li:nth-child(2) a').trigger('tap');
				var patientInfo = $("#content-primary .ui-block-a") .text();
				equal(patientInfo, 'Patient66 (9966)', 'Patient info shows Lastname + last 4 digits of ssn');
				
				var patientInfoFooter = $('#footer-patientname').text().trim().replace(/\s+/g, " ").split(' - ');
				equal(patientInfoFooter[0], 'patient66, zztest', 'Full patient name is displayed');
				equal(patientInfoFooter[1], 'MALE', 'Patient gender is displayed');
				equal(patientInfoFooter[2], '999-99-9966', 'Patient SSN is displayed');
				equal(patientInfoFooter[3], '01/01/1900', 'Patient DOB is displayed');
				equal(patientInfoFooter[4], '113', 'Patient age is displayed');
			});
		});
		
	};
	
	return {
		initialize: defineTests
	};
});
