define([
    'jQuery',
    'Underscore',
    'asyncSeries'
], function ($$, Underscore, asyncSeries) {

    module("#5DetailsDisplay - Confirm details functionality");

    //find element by selector
    //text length check ensures we got back a valid element
    function okElementContains(selector, expectedText, okMessage) {
        ok($(selector + ':contains(' + expectedText + ')').text().length > 0, okMessage);
    }

    function okFieldValueText(selector, expectedText, okMessage) {
        ok($(selector).text() === expectedText, okMessage);
    }

    test("Selecting AR row displays details", function () {
        asyncSeries(function () {
            //sometimes test fails because the table is empty, not sure how it gets in that state?
            return 1000;
        }, function () {

            if ($('#appointmentRequestTable tr:nth-child(1)').size() === 0) {
                ok(false, "Row available to click");
            }

            //Go to request details and validate the information text
            $('#appointmentRequestTable tr:nth-child(1)').trigger('tap');

        }, function () {
            //patient name displayed
            okElementContains('#content-primary h2', 'zztest patient66', "Patient Name displays in header");
            okElementContains('#content-primary span.fieldvalue', 'Submitted', "AR Status displays");
            okElementContains('#content-primary span.fieldvalue', 'zztest patient66', "Patient Name displays in details");
            okElementContains('#content-primary span.fieldvalue', 'Jan 01, 1900', "DOB displays in details");
            okElementContains('#content-primary span.fieldvalue', '999999966', "SSN displays in details");
            okFieldValueText('#content-primary span.fieldname:contains("Last Activity") ~ span', 'Sunday March 17, 2013 1:00 AM', "Last Activity displays in details");
            okFieldValueText('#content-primary span.fieldname:contains("Request Submitted") ~ span', 'Sunday March 17, 2013 12:59 AM', "Request Submitted displays in details");
            okElementContains('#content-primary span.fieldvalue', 'DC VAMC', "Facility displays in details");
            okElementContains('#content-primary span.fieldvalue', 'Primary Care', "Type of Care displays in details");
            okElementContains('#content-primary span.fieldvalue', 'zztest appointment_provider1', "Provider displays in details");
            okElementContains('#content-primary span.fieldvalue', 'Office Visit', "Type of Visit displays in details");
            okElementContains('#content-primary span.fieldvalue', 'Routine follow-up', "Purpose of Visit displays in details");
            okElementContains('#content-primary span.fieldvalue', '03/27/2013 AM', "Preferreddisplays in details");
            okElementContains('#content-primary span.fieldvalue', '03/28/2013 AM', "Second Choice displays in details");
            okElementContains('#content-primary span.fieldvalue', '03/29/2013 AM', "Third Choice displays in details");
            okElementContains('#content-primary span.fieldvalue', 'test@test', "Email displays in details");
            okElementContains('#content-primary span.fieldvalue', '123-456-7890', "Phone displays in details");
            okElementContains('#content-primary span.fieldvalue', '9 AM - 11 AM', "Best Time to Call displays in details");
            okElementContains('#content-primary span.fieldvalue', 'No', "Text Message Allowed displays in details");
        });
    });
});

